/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterator.SingleElementIterator;

public class SingleElementIteratorTests
extends TestCase {
    public SingleElementIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildSingleElementIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        SingleElementIteratorTests.assertEquals((int)1, (int)i);
    }

    public void testNext() {
        Iterator<String> stream = this.buildSingleElementIterator();
        while (stream.hasNext()) {
            SingleElementIteratorTests.assertEquals((String)"bogus element", (String)this.singleElement(), (String)stream.next());
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildSingleElementIterator();
        String string = stream.next();
        try {
            string = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        SingleElementIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testRemove() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildSingleElementIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals(this.singleElement())) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        SingleElementIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    protected Iterator<String> buildSingleElementIterator() {
        return new SingleElementIterator((Object)this.singleElement());
    }

    protected String singleElement() {
        return "single element";
    }
}

