/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.contentassist;

import java.io.File;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.xsl.ui.tests.AbstractSourceViewerTest;
import org.junit.Assert;
import org.junit.Test;

public class TestXPathXMLCompletionProposal
extends AbstractSourceViewerTest {
    @Test
    public void testProposalsIncludeXSD() throws Exception {
        this.fileName = "TestXPathXMLProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(5, 29);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        int i = 0;
        while (i < proposals.length) {
            if (proposals[i].getDisplayString().contains("xsd:")) {
                return;
            }
            ++i;
        }
        Assert.fail((String)"Did not find XSD proposals.");
    }

    @Test
    public void testProposalsIncludeAfterColon() throws Exception {
        this.fileName = "TestXPathXMLProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(11, 44);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        int i = 0;
        while (i < proposals.length) {
            if (proposals[i].getDisplayString().contains("xsd:")) {
                return;
            }
            ++i;
        }
        Assert.fail((String)"Did not find XSD proposals.");
    }

    @Test
    public void testProposalsIncludeXSDAfterForwardSlash() throws Exception {
        this.fileName = "TestXPathXMLProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(8, 41);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        int i = 0;
        while (i < proposals.length) {
            if (proposals[i].getDisplayString().contains("xsd:")) {
                return;
            }
            ++i;
        }
        Assert.fail((String)"Did not find XSD proposals.");
    }

    @Test
    public void testBug337649() throws Exception {
        this.fileName = "TestXPathXMLProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(17, 20);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
    }

    @Test
    public void testTestAttributeProposal() throws Exception {
        this.fileName = "TestTestAttributeProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(5, 25);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        int i = 0;
        while (i < proposals.length) {
            if (proposals[i].getDisplayString().contains("document")) {
                return;
            }
            ++i;
        }
        Assert.fail((String)"Did not find XPath proposals for the test attribute.");
    }

    @Test
    public void testCurlyBraceProposal() throws Exception {
        this.fileName = "bug294079.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(5, 16);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        int i = 0;
        while (i < proposals.length) {
            if (proposals[i].getDisplayString().contains("document")) {
                return;
            }
            ++i;
        }
        Assert.fail((String)"Did not find XPath proposals for the test attribute.");
    }
}

