/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature;

import java.util.Date;
import java.util.Iterator;
import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.UpdateAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UpdateAttributeFeatureTest {
    private IJPAEditorFeatureProvider featureProvider;
    private ICustomContext context;
    final String TEST_PROJECT = "Test" + new Date().getTime();
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    private IFile entity;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject(String.valueOf(this.TEST_PROJECT) + "_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        this.entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Ent");
        Thread.sleep(2000L);
        this.factory.addAttributes(this.entity, "att", "java.lang.String", "", "att", false);
    }

    @Test
    public void testUpdateAttributeFeature() {
        Text text = (Text)EasyMock.createMock(Text.class);
        text.setValue((String)EasyMock.isA(String.class));
        EasyMock.replay((Object[])new Object[]{text});
        BasicInternalEList listChildren = new BasicInternalEList(GraphicsAlgorithm.class);
        EasyMock.expect((Object)((GraphicsAlgorithm)listChildren.get(0))).andReturn((Object)text);
        EasyMock.replay((Object[])new Object[]{listChildren});
        Rectangle rectangle = (Rectangle)EasyMock.createMock(Rectangle.class);
        EasyMock.expect((Object)rectangle.getGraphicsAlgorithmChildren()).andReturn((Object)listChildren);
        EasyMock.expect((Object)rectangle.getY()).andReturn((Object)0).times(2);
        EasyMock.replay((Object[])new Object[]{rectangle});
        Iterator iteratorShape = (Iterator)EasyMock.createNiceMock(Iterator.class);
        EasyMock.expect((Object)iteratorShape.hasNext()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{iteratorShape});
        BasicInternalEList listShape = new BasicInternalEList(Shape.class);
        ContainerShape containerShape = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)containerShape.getChildren()).andReturn((Object)listShape);
        EasyMock.replay((Object[])new Object[]{containerShape});
        Shape shape = (Shape)EasyMock.createMock(Shape.class);
        Resource res = (Resource)EasyMock.createMock(Resource.class);
        ResourceSet rs = (ResourceSet)EasyMock.createMock(ResourceSet.class);
        EasyMock.expect((Object)res.getResourceSet()).andStubReturn((Object)rs);
        BasicInternalEList ads = new BasicInternalEList(Adapter.class);
        EasyMock.expect((Object)rs.eAdapters()).andStubReturn((Object)ads);
        EasyMock.expect((Object)shape.eResource()).andStubReturn((Object)res);
        EasyMock.expect((Object)shape.getGraphicsAlgorithm()).andReturn((Object)rectangle).times(3);
        EasyMock.expect((Object)shape.getContainer()).andReturn((Object)containerShape);
        EasyMock.replay((Object[])new Object[]{shape, res, rs});
        this.context = (ICustomContext)EasyMock.createMock(ICustomContext.class);
        EasyMock.expect((Object)this.context.getInnerPictogramElement()).andReturn((Object)shape);
        EasyMock.replay((Object[])new Object[]{this.context});
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement((PictogramElement)shape)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
        UpdateAttributeFeature feature = new UpdateAttributeFeature((IFeatureProvider)this.featureProvider);
        feature.execute(this.context);
    }
}

