/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.resources;

import java.util.regex.Pattern;
import junit.framework.Assert;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceIdentifier;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceIdentifierFactory;
import org.eclipse.jst.jsf.test.util.junit4.NoPluginEnvironment;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NoPluginEnvironment.class})
public class TestResourceIdentifierFactory {
    private ResourceIdentifierFactory _factory;

    @Before
    public void setUp() throws Exception {
        this._factory = new ResourceIdentifierFactory();
    }

    @Test
    public void testCreateLibraryResource() throws ResourceIdentifierFactory.InvalidIdentifierException {
        ResourceIdentifier id = this._factory.createLibraryResource("resourceOnly");
        Assert.assertEquals((String)"resourceOnly", (String)id.getResourceName());
        id = this._factory.createLibraryResource("libName/resourceName");
        Assert.assertEquals((String)"resourceName", (String)id.getResourceName());
        Assert.assertEquals((String)"libName", (String)id.getLibraryName());
        id = this._factory.createLibraryResource("libName/1_0/resourceName");
        Assert.assertEquals((String)"resourceName", (String)id.getResourceName());
        Assert.assertEquals((String)"libName", (String)id.getLibraryName());
        id = this._factory.createLibraryResource("locale/libraryName/1_0/resourceName");
        Assert.assertEquals((String)"resourceName", (String)id.getResourceName());
        Assert.assertEquals((String)"libraryName", (String)id.getLibraryName());
        id = this._factory.createLibraryResource("libraryName/1_0/resourceName/resourceVersion");
        Assert.assertEquals((String)"resourceName", (String)id.getResourceName());
        Assert.assertEquals((String)"libraryName", (String)id.getLibraryName());
        id = this._factory.createLibraryResource("locale/libraryName/resourceName/resourceVersion");
        Assert.assertEquals((String)"resourceName", (String)id.getResourceName());
        Assert.assertEquals((String)"libraryName", (String)id.getLibraryName());
        id = this._factory.createLibraryResource("locale/libraryName/1_0/resourceName/resourceVersion");
        Assert.assertEquals((String)"resourceName", (String)id.getResourceName());
        Assert.assertEquals((String)"libraryName", (String)id.getLibraryName());
    }

    @Test(expected=ResourceIdentifierFactory.InvalidIdentifierException.class)
    public void testCreateLibraryResource_InvalidId_BadLibVersion() throws ResourceIdentifierFactory.InvalidIdentifierException {
        this._factory.createLibraryResource("libraryName/bad_version/resourceName");
    }

    @Test
    public void testVersionPatternMatch() {
        Pattern versionPattern = ResourceIdentifierFactory.VersionPattern;
        Assert.assertTrue((boolean)versionPattern.matcher("1").matches());
        Assert.assertTrue((boolean)versionPattern.matcher("12").matches());
        Assert.assertTrue((boolean)versionPattern.matcher("123").matches());
        Assert.assertTrue((boolean)versionPattern.matcher("1_0").matches());
        Assert.assertTrue((boolean)versionPattern.matcher("12_10").matches());
        Assert.assertTrue((boolean)versionPattern.matcher("129_10").matches());
        Assert.assertTrue((boolean)versionPattern.matcher("12_10_1").matches());
        Assert.assertFalse((boolean)versionPattern.matcher("_").matches());
        Assert.assertFalse((boolean)versionPattern.matcher("1_").matches());
        Assert.assertFalse((boolean)versionPattern.matcher("_0").matches());
        Assert.assertFalse((boolean)versionPattern.matcher("1_0_").matches());
        Assert.assertFalse((boolean)versionPattern.matcher("a").matches());
        Assert.assertFalse((boolean)versionPattern.matcher("a_0").matches());
        Assert.assertFalse((boolean)versionPattern.matcher("1_0a").matches());
    }
}

