/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.ui.tests.internal.JsStorageEditorInput;

public class EditorTests
extends TestCase {
    public EditorTests() {
    }

    public EditorTests(String name) {
        super(name);
    }

    public void testOpenEditorWithStorageEditorInput() throws PartInitException {
        JsStorageEditorInput input = new JsStorageEditorInput("var a = {};", (IPath)new Path("/" + this.getName() + "/testfile.js"));
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)"org.eclipse.wst.jsdt.ui.CompilationUnitEditor", (boolean)true);
        EditorTests.assertTrue((String)"unexpected editor opened", (editor instanceof JavaEditor && editor instanceof ITextEditor ? 1 : 0) != 0);
        IAnnotationModel annotationModel = ((ITextEditor)editor).getDocumentProvider().getAnnotationModel((Object)input);
        EditorTests.assertNotNull((String)"no annotation model present", (Object)annotationModel);
        IDocument document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)input);
        EditorTests.assertNotNull((String)"no text document present", (Object)document);
        EditorTests.assertTrue((String)"text document is empty", (document.getLength() > 0 ? 1 : 0) != 0);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().layout(true, true);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().redraw();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editor, false);
    }

    public void testOpenEditorWithEmptyStorageEditorInput() throws PartInitException {
        JsStorageEditorInput input = new JsStorageEditorInput("", (IPath)new Path("/" + this.getName() + "/testfile.js"));
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)"org.eclipse.wst.jsdt.ui.CompilationUnitEditor", (boolean)true);
        EditorTests.assertTrue((String)"unexpected editor opened", (editor instanceof JavaEditor && editor instanceof ITextEditor ? 1 : 0) != 0);
        IAnnotationModel annotationModel = ((ITextEditor)editor).getDocumentProvider().getAnnotationModel((Object)input);
        EditorTests.assertNotNull((String)"no annotation model present", (Object)annotationModel);
        IDocument document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)input);
        EditorTests.assertNotNull((String)"no text document present", (Object)document);
        EditorTests.assertTrue((String)"text document is not empty", (document.getLength() == 0 ? 1 : 0) != 0);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editor, false);
    }
}

