/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.preferences;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.validation.el.tests.preferences.PrefTestUtil;
import org.eclipse.jst.jsf.validation.internal.ELValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.Severity;

public class TestELValidationPreferences
extends TestCase {
    private ELValidationPreferences _prefs;

    protected void setUp() throws Exception {
        super.setUp();
        this._prefs = new ELValidationPreferences();
        this._prefs.load(JSFCorePlugin.getDefault().getPreferenceStore());
        PrefTestUtil.assertExpectedDefaults(this._prefs);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._prefs.setDefaults();
        PrefTestUtil.assertExpectedDefaults(this._prefs);
        this._prefs.commit(JSFCorePlugin.getDefault().getPreferenceStore());
        ((IPersistentPreferenceStore)JSFCorePlugin.getDefault().getPreferenceStore()).save();
    }

    public void testLoad() {
        PrefTestUtil.assertExpectedDefaults(this._prefs);
    }

    public void testSetDefaults() {
        this._prefs.setDefaults();
        PrefTestUtil.assertExpectedDefaults(this._prefs);
    }

    public void testSetByKey() {
        PrefTestUtil.setByKey(Severity.IGNORE, this._prefs);
        PrefTestUtil.assertSetByKey(Severity.IGNORE, this._prefs);
    }

    public void testSetByKeyAndSave() throws IOException {
        IPreferenceStore prefStore = JSFCorePlugin.getDefault().getPreferenceStore();
        PrefTestUtil.setByKey(Severity.IGNORE, this._prefs);
        PrefTestUtil.assertSetByKey(Severity.IGNORE, this._prefs);
        this._prefs.commit(prefStore);
        ((IPersistentPreferenceStore)prefStore).save();
        this._prefs.load(prefStore);
        PrefTestUtil.assertSetByKey(Severity.IGNORE, this._prefs);
    }
}

