/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.jmock.testcases;

import java.lang.reflect.Method;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.jst.ws.jaxws.testutils.jmock.testcases.IBeforeAfterEnabled;

public class BeforeAfterEnabler {
    private final IBeforeAfterEnabled tc;
    private int testCount = 0;
    private final int totalTestCount;
    private boolean disableAfterTestCase = false;

    public BeforeAfterEnabler(IBeforeAfterEnabled tc) {
        this.tc = tc;
        this.totalTestCount = this.countTotalTests();
    }

    public void runBare() throws Throwable {
        Throwable exception = null;
        if (this.testCount == 0) {
            this.beforeTestCase();
        }
        ++this.testCount;
        try {
            this.tc.runBareInternal();
        }
        catch (Throwable running) {
            exception = running;
        }
        if (this.testCount == this.totalTestCount) {
            if (!this.disableAfterTestCase) {
                try {
                    this.afterTestCase();
                }
                catch (Exception afterTestCase) {
                    if (exception == null) {
                        exception = afterTestCase;
                    }
                }
            } else {
                this.disableAfterTestCase = false;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void disableAfterTestCase() {
        this.disableAfterTestCase = true;
    }

    protected void beforeTestCase() throws Exception {
        this.tc.beforeTestCase();
    }

    protected void afterTestCase() throws Exception {
        this.tc.afterTestCase();
    }

    private int countTotalTests() {
        int count = 0;
        Class<?> superClass = this.tc.getClass();
        Vector<String> names = new Vector<String>();
        while (Test.class.isAssignableFrom(superClass)) {
            Method[] methods;
            Method[] methodArray = methods = superClass.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                String name = method.getName();
                if (!names.contains(name)) {
                    names.addElement(name);
                    if (this.isTestMethod(method)) {
                        ++count;
                    }
                }
                ++n2;
            }
            superClass = superClass.getSuperclass();
        }
        return count;
    }

    private boolean isTestMethod(Method m) {
        String name = m.getName();
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
    }
}

