/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal;

import junit.framework.Assert;
import org.eclipse.wst.jsdt.chromium.Breakpoint;

public class TestUtil {
    private static final Breakpoint.Target.Visitor<String> BREAKPOINT_TARGET_DUMPER = new Breakpoint.Target.Visitor<String>(){

        public String visitScriptName(String scriptName) {
            return "name=" + scriptName;
        }

        public String visitScriptId(Object scriptId) {
            return "id=" + scriptId;
        }

        public String visitUnknown(Breakpoint.Target target) {
            return "unknown " + target;
        }
    };

    public static void assertBreakpointsEqual(Breakpoint bpExpected, Breakpoint bpHit) {
        Assert.assertEquals((long)bpExpected.getId(), (long)bpHit.getId());
        Assert.assertEquals((String)bpExpected.getCondition(), (String)bpHit.getCondition());
        Assert.assertEquals((String)((String)bpExpected.getTarget().accept(BREAKPOINT_TARGET_DUMPER)), (String)((String)bpHit.getTarget().accept(BREAKPOINT_TARGET_DUMPER)));
    }

    private TestUtil() {
    }
}

