/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.internal.TestUtil;
import org.eclipse.wst.jsdt.chromium.internal.browserfixture.AbstractAttachedTest;
import org.eclipse.wst.jsdt.chromium.internal.transport.FakeConnection;
import org.junit.Assert;
import org.junit.Test;

public class DebugEventListenerTest
extends AbstractAttachedTest<FakeConnection> {
    @Test
    public void testDetach() throws Exception {
        Assert.assertTrue((boolean)this.javascriptVm.detach());
        Assert.assertFalse((boolean)this.javascriptVm.isAttached());
        Assert.assertTrue((boolean)this.isDisconnected);
    }

    @Test(timeout=5000L)
    public void testSuspendResume() throws Exception {
        final Breakpoint[] bp = new Breakpoint[1];
        final String[] failure = new String[1];
        final CountDownLatch latch = new CountDownLatch(1);
        Breakpoint.Target.ScriptName target = new Breakpoint.Target.ScriptName("file:///C:/1.js");
        this.javascriptVm.setBreakpoint((Breakpoint.Target)target, 18, 3, true, null, new JavascriptVm.BreakpointCallback(){

            public void failure(String errorMessage) {
                failure[0] = errorMessage == null ? "" : errorMessage;
                latch.countDown();
            }

            public void success(Breakpoint breakpoint) {
                bp[0] = breakpoint;
                latch.countDown();
            }
        }, null);
        latch.await();
        Assert.assertNull((String)("Failed to set a breakpoint: " + failure[0]), (Object)failure[0]);
        Assert.assertNotNull((String)"Breakpoint not set", (Object)bp[0]);
        latch = this.expectSuspend();
        this.messageResponder.hitBreakpoints(Collections.singleton(bp[0].getId()));
        latch.await();
        Assert.assertNotNull((String)"suspended() not invoked after the break event", (Object)this.suspendContext);
        Collection breakpointsHit = this.suspendContext.getBreakpointsHit();
        Assert.assertEquals((long)1L, (long)breakpointsHit.size());
        Breakpoint bpHit = (Breakpoint)breakpointsHit.iterator().next();
        TestUtil.assertBreakpointsEqual(bp[0], bpHit);
        this.resume();
        CountDownLatch latch2 = this.expectSuspend();
        this.messageResponder.hitBreakpoints(Collections.<Long>emptySet());
        latch2.await();
        Assert.assertNotNull((String)"suspended() not invoked after the break event", (Object)this.suspendContext);
        breakpointsHit = this.suspendContext.getBreakpointsHit();
        Assert.assertTrue((boolean)breakpointsHit.isEmpty());
        this.resume();
    }

    @Override
    protected FakeConnection createConnection() {
        return new FakeConnection(this.messageResponder);
    }
}

