/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraphEvent;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraphReferences;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraphListener;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraphReferences;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class DependencyGraphImpl
implements IDependencyGraph {
    private final Object graphLock = new Object();
    private Map<IProject, Set<IProject>> graph;
    private final AtomicLong modStamp = new AtomicLong();
    private final ListenerList listeners = new ListenerList();
    private final Object jobLock = new Object();
    private int pauseCount;
    private static DependencyGraphImpl instance;
    private DependencyGraphResourceChangedListener listener;
    public static final Object GRAPH_UPDATE_JOB_FAMILY;
    private static final int JOB_DELAY = 100;
    private final GraphUpdateJob graphUpdateJob = new GraphUpdateJob();
    private final ILock jobILock = Job.getJobManager().newLock();
    private static final String DEPENDENCY_GRAPH_CACHE = "dependencyCache.index";
    private static final int persistDelay = 60000;
    private final PersistJob persistJob = new PersistJob();

    static {
        GRAPH_UPDATE_JOB_FAMILY = new Object();
    }

    static IDependencyGraph getInstance() {
        if (instance == null) {
            instance = new DependencyGraphImpl();
            instance.initGraph();
        }
        return instance;
    }

    private DependencyGraphImpl() {
    }

    @Override
    public long getModStamp() {
        return this.modStamp.get();
    }

    private void incrementModStamp() {
        this.modStamp.incrementAndGet();
    }

    @Override
    public Set<IProject> getReferencingComponents(IProject targetProject) {
        IDependencyGraphReferences refs = this.getReferencingComponents(targetProject, true);
        return refs.getReferencingComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDependencyGraphReferences getReferencingComponents(IProject targetProject, boolean waitForAllUpdates) {
        DependencyGraphReferences refs = new DependencyGraphReferences();
        refs.targetProject = targetProject;
        if (waitForAllUpdates) {
            refs.stale = false;
            this.waitForAllUpdates(null);
        } else if (this.isUpdateNecessary()) {
            refs.stale = true;
        }
        Object object = this.graphLock;
        synchronized (object) {
            Set<IProject> set = this.graph.get(targetProject);
            if (set == null) {
                refs.referencingProjects = Collections.EMPTY_SET;
            } else {
                DependencyGraphEvent event = null;
                Iterator<IProject> iterator = set.iterator();
                while (iterator.hasNext()) {
                    IProject sourceProject = iterator.next();
                    if (sourceProject.isAccessible()) continue;
                    iterator.remove();
                    if (event == null) {
                        this.incrementModStamp();
                        event = new DependencyGraphEvent();
                        event.setModStamp(this.getModStamp());
                    }
                    event.removeReference(sourceProject, targetProject);
                }
                if (event != null) {
                    this.notifiyListeners(event);
                }
                HashSet<IProject> copy = new HashSet<IProject>();
                copy.addAll(set);
                refs.referencingProjects = copy;
            }
        }
        return refs;
    }

    @Override
    public boolean isStale() {
        return this.isUpdateNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGraph() {
        Object object = this.graphLock;
        synchronized (object) {
            try {
                this.preUpdate();
                this.graph = new HashMap<IProject, Set<IProject>>();
                this.listener = new DependencyGraphResourceChangedListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener, 1);
                if (this.restoreGraph() == null) {
                    this.rebuild();
                }
            }
            finally {
                this.postUpdate();
            }
        }
    }

    private void rebuild() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.rebuild(allProjects);
    }

    private void rebuild(IProject[] allProjects) {
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject sourceProject = iProjectArray[n2];
            this.update(sourceProject, 1);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllReferences(DependencyGraphEvent event) {
        Object object = this.graphLock;
        synchronized (object) {
            IProject[] allReferenceKeys = new IProject[this.graph.keySet().size()];
            this.graph.keySet().toArray(allReferenceKeys);
            IProject[] iProjectArray = allReferenceKeys;
            int n = allReferenceKeys.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                this.removeAllReferences(project, event);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllReferences(IProject targetProject, DependencyGraphEvent event) {
        Object object = this.graphLock;
        synchronized (object) {
            boolean removed = false;
            Set<IProject> removedSet = this.graph.remove(targetProject);
            if (removedSet != null && !removedSet.isEmpty()) {
                removed = true;
                for (IProject project : removedSet) {
                    event.removeReference(project, targetProject);
                }
            }
            for (Map.Entry<IProject, Set<IProject>> entry : this.graph.entrySet()) {
                if (entry.getValue().isEmpty() || !entry.getValue().remove(targetProject)) continue;
                removed = true;
                event.removeReference(targetProject, entry.getKey());
            }
            if (removed) {
                this.incrementModStamp();
                event.setModStamp(this.getModStamp());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReference(IProject sourceProject, IProject targetProject, DependencyGraphEvent event) {
        Object object = this.graphLock;
        synchronized (object) {
            Set<IProject> referencingProjects = this.graph.get(targetProject);
            if (referencingProjects != null && referencingProjects.remove(sourceProject)) {
                event.removeReference(sourceProject, targetProject);
                this.incrementModStamp();
                event.setModStamp(this.getModStamp());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReference(IProject sourceProject, IProject targetProject, DependencyGraphEvent event) {
        Object object = this.graphLock;
        synchronized (object) {
            boolean added;
            Set<IProject> referencingProjects = this.graph.get(targetProject);
            if (referencingProjects == null) {
                referencingProjects = new HashSet<IProject>();
                this.graph.put(targetProject, referencingProjects);
            }
            if (added = referencingProjects.add(sourceProject)) {
                event.addRefererence(sourceProject, targetProject);
                this.incrementModStamp();
                event.setModStamp(this.getModStamp());
            }
        }
    }

    @Override
    public void addListener(IDependencyGraphListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IDependencyGraphListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifiyListeners(final DependencyGraphEvent event) {
        if (event.getType() == 0) {
            return;
        }
        Job notificationJob = new Job(Resources.NOTIFICATION_JOB_NAME){

            protected IStatus run(final IProgressMonitor monitor) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        Object[] objectArray = DependencyGraphImpl.this.listeners.getListeners();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object listener = objectArray[n2];
                            ((IDependencyGraphListener)listener).dependencyGraphUpdate(event);
                            ++n2;
                        }
                        DependencyGraphImpl.this.saveGraph();
                        monitor.done();
                    }

                    public void handleException(Throwable exception) {
                        ModulecorePlugin.logError(exception);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        notificationJob.setSystem(true);
        notificationJob.setRule(null);
        notificationJob.schedule();
    }

    public void queueProjectAdded(IProject project) {
        this.update(project, 1);
    }

    public void queueProjectDeleted(IProject project) {
        this.update(project, 2);
    }

    @Override
    public void update(IProject project) {
        this.update(project, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IProject project, int updateType) {
        switch (updateType) {
            case 0: {
                this.graphUpdateJob.queueProjectUpdated(project);
                break;
            }
            case 1: {
                this.graphUpdateJob.queueProjectAdded(project);
                break;
            }
            case 2: {
                this.graphUpdateJob.queueProjectDeleted(project);
            }
        }
        Object object = this.jobLock;
        synchronized (object) {
            if (this.pauseCount > 0) {
                return;
            }
            this.graphUpdateJob.schedule(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preUpdate() {
        Object object = this.jobLock;
        synchronized (object) {
            ++this.pauseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postUpdate() {
        Object object = this.jobLock;
        synchronized (object) {
            if (this.pauseCount > 0) {
                --this.pauseCount;
            }
            if (this.pauseCount > 0) {
                return;
            }
            this.graphUpdateJob.schedule(100L);
        }
    }

    public void waitForAllUpdates(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.subTask(Resources.WAITING);
        Job currentJob = Job.getJobManager().currentJob();
        if (currentJob != this.graphUpdateJob) {
            if (Job.getJobManager().isSuspended()) {
                Job.getJobManager().resume();
            }
            while (this.isUpdateNecessary()) {
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.graphUpdateJob.shouldSchedule()) {
                    this.graphUpdateJob.schedule();
                }
                this.graphUpdateJob.wakeUp();
                if (currentJob != null && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                    currentJob.yieldRule((IProgressMonitor)subMonitor.newChild(100));
                }
                this.graphUpdateJob.waitForRun(500L);
                boolean interrupted = false;
                try {
                    if (!this.jobILock.acquire(500L)) continue;
                    this.jobILock.release();
                    if (this.isUpdateNecessary()) continue;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private boolean isUpdateNecessary() {
        return this.graphUpdateJob.getState() != 0 || this.graphUpdateJob.shouldSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private RestoredGraphResults restoreGraph() {
        try {
            Object object = this.graphLock;
            synchronized (object) {
                this.graph = new HashMap<IProject, Set<IProject>>();
                IPath stateLocation = ModulecorePlugin.getDefault().getStateLocation();
                File file = stateLocation.append(DEPENDENCY_GRAPH_CACHE).toFile();
                if (!file.exists()) {
                    return null;
                }
                HashMap savedMap = null;
                FileInputStream fIn = null;
                boolean deleteCache = true;
                try {
                    try {
                        fIn = new FileInputStream(file);
                        BufferedInputStream bIn = new BufferedInputStream(fIn);
                        ObjectInputStream oIn = new ObjectInputStream(bIn);
                        savedMap = (HashMap)oIn.readObject();
                        oIn.close();
                        deleteCache = false;
                    }
                    catch (FileNotFoundException e) {
                        ModulecorePlugin.logError(e);
                        if (fIn != null) {
                            try {
                                fIn.close();
                            }
                            catch (IOException e2) {
                                ModulecorePlugin.logError(e2);
                            }
                        }
                        if (deleteCache) {
                            file.delete();
                        }
                        return null;
                    }
                    catch (IOException e) {
                        block40: {
                            ModulecorePlugin.logError(e);
                            if (fIn == null) break block40;
                            try {
                                fIn.close();
                            }
                            catch (IOException e3) {
                                ModulecorePlugin.logError(e3);
                            }
                        }
                        if (deleteCache) {
                            file.delete();
                        }
                        return null;
                    }
                    catch (ClassNotFoundException e) {
                        block41: {
                            ModulecorePlugin.logError(e);
                            if (fIn == null) break block41;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            try {
                                fIn.close();
                            }
                            catch (IOException e4) {
                                ModulecorePlugin.logError(e4);
                            }
                        }
                        if (deleteCache) {
                            file.delete();
                        }
                        return null;
                    }
                }
                finally {
                    if (fIn != null) {
                        try {
                            fIn.close();
                        }
                        catch (IOException e) {
                            ModulecorePlugin.logError(e);
                        }
                    }
                    if (deleteCache) {
                        file.delete();
                    }
                }
                if (savedMap != null) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    for (String sourceProjectName : savedMap.keySet()) {
                        IProject sourceProject = root.getProject(sourceProjectName);
                        if (!sourceProject.exists()) {
                            return null;
                        }
                        Set targetProjectNames = (Set)savedMap.get(sourceProjectName);
                        for (String targetProjectName : targetProjectNames) {
                            IProject targetProject = root.getProject(targetProjectName);
                            if (targetProject.exists()) continue;
                            return null;
                        }
                    }
                    DependencyGraphEvent event = new DependencyGraphEvent();
                    this.incrementModStamp();
                    event = new DependencyGraphEvent();
                    event.setModStamp(this.getModStamp());
                    Set entries = savedMap.entrySet();
                    for (Map.Entry entry : entries) {
                        IProject sourceProject = root.getProject((String)entry.getKey());
                        for (String targetProjectName : (Set)entry.getValue()) {
                            IProject targetProject = root.getProject(targetProjectName);
                            this.addReference(targetProject, sourceProject, event);
                        }
                    }
                    RestoredGraphResults results = new RestoredGraphResults();
                    results.event = event;
                    results.graph = savedMap;
                    this.checkRestoredResults(results);
                    return results;
                }
            }
        }
        catch (Throwable e) {
            try {
                ModulecorePlugin.logError(e);
                IPath stateLocation = ModulecorePlugin.getDefault().getStateLocation();
                File file = stateLocation.append(DEPENDENCY_GRAPH_CACHE).toFile();
                file.delete();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private void saveGraph() {
        this.persistJob.schedule(60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void persist() {
        HashMap savedMap = null;
        Object object = this.graphLock;
        synchronized (object) {
            savedMap = new HashMap(this.graph.size());
            for (IProject sourceProject : this.graph.keySet()) {
                HashSet<String> savedTargets = new HashSet<String>();
                for (IProject targetProject : this.graph.get(sourceProject)) {
                    savedTargets.add(targetProject.getName());
                }
                savedMap.put(sourceProject.getName(), savedTargets);
            }
        }
        IPath stateLocation = ModulecorePlugin.getDefault().getStateLocation();
        File file = stateLocation.append(DEPENDENCY_GRAPH_CACHE).toFile();
        if (savedMap.isEmpty()) {
            if (!file.exists()) return;
            file.delete();
            return;
        }
        FileOutputStream fOut = null;
        try {
            try {
                fOut = new FileOutputStream(file);
                BufferedOutputStream bOut = new BufferedOutputStream(fOut);
                ObjectOutputStream oOut = new ObjectOutputStream(bOut);
                oOut.writeObject(savedMap);
                oOut.close();
                return;
            }
            catch (FileNotFoundException e) {
                ModulecorePlugin.logError(e);
                if (fOut == null) return;
                try {
                    fOut.close();
                    return;
                }
                catch (IOException e2) {
                    ModulecorePlugin.logError(e2);
                }
                return;
            }
            catch (IOException e) {
                ModulecorePlugin.logError(e);
                if (fOut == null) return;
                try {
                    fOut.close();
                    return;
                }
                catch (IOException e3) {
                    ModulecorePlugin.logError(e3);
                }
                return;
            }
        }
        finally {
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (IOException e) {
                    ModulecorePlugin.logError(e);
                }
            }
        }
    }

    private void checkRestoredResults(final RestoredGraphResults restoredGraphResults) {
        Job checkRestoreDataJob = new Job(Resources.CHECK_GRAPH_RESTORE_JOB_NAME){

            protected IStatus run(final IProgressMonitor monitor) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        try {
                            IProject[] allProjects = null;
                            int state = ResourcesPlugin.getPlugin().getBundle().getState();
                            if (state != 32) {
                                return;
                            }
                            allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                            if (this.isStale(allProjects)) {
                                DependencyGraphImpl.this.rebuild(allProjects);
                                DependencyGraphImpl.this.saveGraph();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }

                    private boolean isStale(IProject[] allProjects) {
                        if (restoredGraphResults.event.getModStamp() != DependencyGraphImpl.this.getModStamp()) {
                            return true;
                        }
                        HashMap<String, HashSet<String>> computedGraph = new HashMap<String, HashSet<String>>();
                        IProject[] iProjectArray = allProjects;
                        int n = allProjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject sourceProject = iProjectArray[n2];
                            if (restoredGraphResults.event.getModStamp() != DependencyGraphImpl.this.getModStamp()) {
                                return true;
                            }
                            IVirtualComponent component = ComponentCore.createComponent(sourceProject);
                            if (component instanceof VirtualComponent) {
                                IVirtualReference[] references;
                                IVirtualReference[] iVirtualReferenceArray = references = ((VirtualComponent)component).getRawReferences();
                                int n3 = references.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IProject targetProject;
                                    IVirtualReference ref = iVirtualReferenceArray[n4];
                                    if (restoredGraphResults.event.getModStamp() != DependencyGraphImpl.this.getModStamp()) {
                                        return true;
                                    }
                                    IVirtualComponent targetComponent = ref.getReferencedComponent();
                                    if (targetComponent != null && (targetProject = targetComponent.getProject()) != null && !targetProject.equals((Object)sourceProject)) {
                                        String targetProjectName = targetProject.getName();
                                        String sourceProjectName = sourceProject.getName();
                                        HashSet<String> targetProjects = (HashSet<String>)computedGraph.get(targetProjectName);
                                        if (targetProjects == null) {
                                            targetProjects = new HashSet<String>();
                                            computedGraph.put(targetProjectName, targetProjects);
                                        }
                                        targetProjects.add(sourceProjectName);
                                    }
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        if (restoredGraphResults.event.getModStamp() != DependencyGraphImpl.this.getModStamp()) {
                            return true;
                        }
                        if (!restoredGraphResults.graph.equals(computedGraph)) {
                            return true;
                        }
                        return restoredGraphResults.event.getModStamp() != DependencyGraphImpl.this.getModStamp();
                    }

                    public void handleException(Throwable exception) {
                        ModulecorePlugin.logError(exception);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        checkRestoreDataJob.setSystem(true);
        checkRestoreDataJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        checkRestoreDataJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.graphLock;
        synchronized (object) {
            StringBuffer buff = new StringBuffer("Dependency Graph:\n{\n");
            for (Map.Entry<IProject, Set<IProject>> entry : this.graph.entrySet()) {
                buff.append("  " + entry.getKey().getName() + " -> {");
                Iterator<IProject> mappedProjects = entry.getValue().iterator();
                while (mappedProjects.hasNext()) {
                    buff.append(mappedProjects.next().getName());
                    if (!mappedProjects.hasNext()) continue;
                    buff.append(", ");
                }
                buff.append("}\n");
            }
            buff.append("}");
            return buff.toString();
        }
    }

    private class DependencyGraphResourceChangedListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private DependencyGraphResourceChangedListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                try {
                    DependencyGraphImpl.this.preUpdate();
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    ModulecorePlugin.logError(e);
                    DependencyGraphImpl.this.postUpdate();
                }
            }
            finally {
                DependencyGraphImpl.this.postUpdate();
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    int kind = delta.getKind();
                    IProject project = (IProject)resource;
                    if ((1 & kind) != 0) {
                        DependencyGraphImpl.this.update(project, 1);
                        return false;
                    }
                    if ((2 & kind) != 0) {
                        DependencyGraphImpl.this.update(project, 2);
                        return false;
                    }
                    if ((4 & kind) != 0) {
                        int flags = delta.getFlags();
                        if ((0x4000 & flags) != 0) {
                            boolean isOpen = project.isOpen();
                            if (isOpen) {
                                DependencyGraphImpl.this.update(project, 1);
                            } else {
                                DependencyGraphImpl.this.update(project, 2);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return resource.getName().equals(".settings");
                }
                case 1: {
                    String name = resource.getName();
                    if (name.equals("org.eclipse.wst.common.component")) {
                        if ((delta.getKind() & 1) != 0) {
                            DependencyGraphImpl.this.update(resource.getProject(), 1);
                            break;
                        }
                        DependencyGraphImpl.this.update(resource.getProject(), 0);
                        break;
                    }
                    if (!name.equals(".project")) break;
                    DependencyGraphImpl.this.update(resource.getProject(), 1);
                }
            }
            return false;
        }
    }

    private class GraphUpdateJob
    extends Job {
        private final Queue projectsAdded;
        private final Queue projectsRemoved;
        private final Queue projectsUpdated;
        private final Object runLock;
        private long runStamp;
        private boolean running;

        public GraphUpdateJob() {
            super(Resources.JOB_NAME);
            this.projectsAdded = new Queue();
            this.projectsRemoved = new Queue();
            this.projectsUpdated = new Queue();
            this.runLock = new Object();
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == GRAPH_UPDATE_JOB_FAMILY;
        }

        public void queueProjectAdded(IProject project) {
            DependencyGraphImpl.this.incrementModStamp();
            this.projectsAdded.add(project);
        }

        public void queueProjectDeleted(IProject project) {
            DependencyGraphImpl.this.incrementModStamp();
            this.projectsRemoved.add(project);
        }

        public void queueProjectUpdated(IProject project) {
            DependencyGraphImpl.this.incrementModStamp();
            this.projectsUpdated.add(project);
        }

        public boolean shouldSchedule() {
            boolean isEmpty = this.projectsAdded.isEmpty() && this.projectsRemoved.isEmpty() && this.projectsUpdated.isEmpty();
            return !isEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setRunning(boolean b) {
            Object object = this.runLock;
            synchronized (object) {
                this.running = b;
                if (this.running) {
                    ++this.runStamp;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isRunning() {
            Object object = this.runLock;
            synchronized (object) {
                return this.running;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean didRun(long stamp) {
            Object object = this.runLock;
            synchronized (object) {
                return stamp != this.runStamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForRun(long maxWaitTime) {
            if (this.isRunning()) {
                return;
            }
            long startTime = System.currentTimeMillis();
            long localRunStamp = 0L;
            Object object = this.runLock;
            synchronized (object) {
                localRunStamp = this.runStamp;
            }
            while (System.currentTimeMillis() - startTime <= maxWaitTime) {
                if (this.didRun(localRunStamp)) {
                    return;
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    continue;
                }
                break;
            }
            return;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                DependencyGraphImpl.this.jobILock.acquire();
                this.setRunning(true);
                if (ResourcesPlugin.getPlugin().getBundle().getState() == 8) {
                    DependencyGraphImpl.this.graphUpdateJob.schedule(100L);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                final Object[] removed = this.projectsRemoved.getListeners();
                final Object[] updated = this.projectsUpdated.getListeners();
                final Object[] added = this.projectsAdded.getListeners();
                if (removed.length == 0 && updated.length == 0 && added.length == 0) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                DependencyGraphImpl.this.incrementModStamp();
                if (ResourcesPlugin.getPlugin().getBundle().getState() != 32) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        ModulecorePlugin.logError(e);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws Exception {
                        IProject[] allProjects;
                        int n;
                        DependencyGraphEvent event = new DependencyGraphEvent();
                        if (added.length == 0) {
                            Object object = DependencyGraphImpl.this.graphLock;
                            synchronized (object) {
                                Object[] objectArray = removed;
                                n = removed.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object o = objectArray[n2];
                                    IProject project = (IProject)o;
                                    DependencyGraphImpl.this.removeAllReferences(project, event);
                                    ++n2;
                                }
                            }
                        }
                        if (added.length > 0) {
                            IVirtualComponent component;
                            DependencyGraphImpl.this.removeAllReferences(event);
                            allProjects = null;
                            int state = ResourcesPlugin.getPlugin().getBundle().getState();
                            if (state != 32) {
                                return;
                            }
                            allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                            IProject[] iProjectArray = allProjects;
                            int n3 = allProjects.length;
                            n = 0;
                            while (n < n3) {
                                IProject sourceProject = iProjectArray[n];
                                component = ComponentCore.createComponent(sourceProject);
                                if (component instanceof VirtualComponent) {
                                    ((VirtualComponent)component).flushCache();
                                }
                                ++n;
                            }
                            iProjectArray = allProjects;
                            n3 = allProjects.length;
                            n = 0;
                            while (n < n3) {
                                IProject sourceProject = iProjectArray[n];
                                component = ComponentCore.createComponent(sourceProject);
                                if (component instanceof VirtualComponent) {
                                    IVirtualReference[] references;
                                    IVirtualReference[] iVirtualReferenceArray = references = ((VirtualComponent)component).getRawReferences();
                                    int n4 = references.length;
                                    int n5 = 0;
                                    while (n5 < n4) {
                                        IProject targetProject;
                                        IVirtualReference ref = iVirtualReferenceArray[n5];
                                        IVirtualComponent targetComponent = ref.getReferencedComponent();
                                        if (targetComponent != null && (targetProject = targetComponent.getProject()) != null && !targetProject.equals((Object)sourceProject)) {
                                            DependencyGraphImpl.this.addReference(sourceProject, targetProject, event);
                                        }
                                        ++n5;
                                    }
                                }
                                ++n;
                            }
                        } else if (updated.length > 0) {
                            allProjects = null;
                            int state = ResourcesPlugin.getPlugin().getBundle().getState();
                            if (state != 32) {
                                return;
                            }
                            allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                            HashSet<IProject> validRefs = new HashSet<IProject>();
                            Object[] objectArray = updated;
                            int n6 = updated.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                Object o = objectArray[n7];
                                IProject sourceProject = (IProject)o;
                                IVirtualComponent component = ComponentCore.createComponent(sourceProject);
                                if (component instanceof VirtualComponent) {
                                    IVirtualReference[] references;
                                    validRefs.clear();
                                    ((VirtualComponent)component).flushCache();
                                    IVirtualReference[] iVirtualReferenceArray = references = ((VirtualComponent)component).getRawReferences();
                                    int n8 = references.length;
                                    int n9 = 0;
                                    while (n9 < n8) {
                                        IProject targetProject;
                                        IVirtualReference ref = iVirtualReferenceArray[n9];
                                        IVirtualComponent targetComponent = ref.getReferencedComponent();
                                        if (targetComponent != null && (targetProject = targetComponent.getProject()) != null && !targetProject.equals((Object)sourceProject)) {
                                            validRefs.add(targetProject);
                                        }
                                        ++n9;
                                    }
                                    Object object = DependencyGraphImpl.this.graphLock;
                                    synchronized (object) {
                                        IProject[] iProjectArray = allProjects;
                                        int n10 = allProjects.length;
                                        n8 = 0;
                                        while (n8 < n10) {
                                            IProject targetProject = iProjectArray[n8];
                                            if (validRefs.remove(targetProject)) {
                                                DependencyGraphImpl.this.addReference(sourceProject, targetProject, event);
                                            } else {
                                                DependencyGraphImpl.this.removeReference(sourceProject, targetProject, event);
                                            }
                                            ++n8;
                                        }
                                    }
                                } else {
                                    DependencyGraphImpl.this.removeAllReferences(sourceProject, event);
                                }
                                ++n7;
                            }
                        }
                        DependencyGraphImpl.this.notifiyListeners(event);
                    }
                });
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                this.setRunning(false);
                DependencyGraphImpl.this.jobILock.release();
            }
        }

        private class Queue
        extends ListenerList {
            private Queue() {
            }

            public synchronized Object[] getListeners() {
                Object[] data = super.getListeners();
                this.clear();
                return data;
            }

            public boolean isEmpty() {
                return super.isEmpty();
            }
        }
    }

    private class PersistJob
    extends Job {
        public PersistJob() {
            super(Resources.GRAPH_SAVE_JOB_NAME);
            this.setSystem(true);
            this.setRule(null);
        }

        protected IStatus run(IProgressMonitor monitor) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    DependencyGraphImpl.this.persist();
                }

                public void handleException(Throwable exception) {
                    ModulecorePlugin.logError(exception);
                }
            });
            return Status.OK_STATUS;
        }
    }

    public static final class Resources
    extends NLS {
        public static String WAITING;
        public static String JOB_NAME;
        public static String NOTIFICATION_JOB_NAME;
        public static String CHECK_GRAPH_RESTORE_JOB_NAME;
        public static String GRAPH_SAVE_JOB_NAME;

        static {
            Resources.initializeMessages((String)DependencyGraphImpl.class.getName(), Resources.class);
        }
    }

    private static final class RestoredGraphResults {
        private DependencyGraphEvent event;
        private HashMap<String, Set<String>> graph;

        private RestoredGraphResults() {
        }
    }
}

