/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.threading;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.jaxws.testutils.threading.TestContextThread;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.eclipse.swt.widgets.Display;

public class TestContext {
    public static void run(IRunnableWithProgress operation, boolean fork, IProgressMonitor monitor, Display display) throws InvocationTargetException, InterruptedException {
        boolean willFork;
        ContractChecker.nullCheckParam((Object)operation, (String)"operation");
        boolean bl = willFork = !TestContext.isInTestContextThread() && fork;
        if (willFork) {
            TestContext.runInTestContextThread(operation, monitor, display);
        } else {
            TestContext.runInCurrentThread(operation, monitor);
        }
    }

    private static void runInCurrentThread(IRunnableWithProgress operation, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        operation.run(monitor);
    }

    private static void runInTestContextThread(IRunnableWithProgress runnable, IProgressMonitor monitor, Display display) throws InvocationTargetException {
        TestContextThread contextThread = new TestContextThread(runnable, monitor, display);
        contextThread.start();
        contextThread.block();
        if (contextThread.getError() != null) {
            if (contextThread.getError() instanceof InvocationTargetException) {
                throw (InvocationTargetException)contextThread.getError();
            }
            throw new InvocationTargetException(contextThread.getError());
        }
    }

    private static boolean isInTestContextThread() {
        Thread t = Thread.currentThread();
        return t instanceof TestContextThread;
    }
}

