/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.ui.tests.internal;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jst.ws.jaxws.dom.runtime.IPropertyState;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomPackage;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IJavaWebServiceElement;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WebParamKind;
import org.eclipse.jst.ws.jaxws.dom.ui.DomItemProviderAdapterFactory;
import org.eclipse.jst.ws.jaxws.dom.ui.IJavaWebServiceElementItemProvider;
import org.eclipse.jst.ws.jaxws.dom.ui.IServiceEndpointInterfaceItemProvider;
import org.eclipse.jst.ws.jaxws.dom.ui.IWebMethodItemProvider;
import org.eclipse.jst.ws.jaxws.dom.ui.IWebParamItemProvider;
import org.eclipse.jst.ws.jaxws.dom.ui.IWebServiceItemProvider;
import org.eclipse.jst.ws.jaxws.dom.ui.IWebServiceProjectItemProvider;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;

public class AllDomItemProviderTest
extends MockObjectTestCase {
    private DomItemProviderAdapterFactory itemProvider;

    public void setUp() {
        this.itemProvider = new DomItemProviderAdapterFactory();
    }

    public void tearDown() {
        this.itemProvider.dispose();
    }

    public void testDOMItemProvider() {
        AllDomItemProviderTest.assertNotNull((Object)this.itemProvider.getRootAdapterFactory());
        this.itemProvider.setParentAdapterFactory(null);
        AllDomItemProviderTest.assertNotNull((Object)this.itemProvider.getRootAdapterFactory());
        this.itemProvider.removeListener(null);
        AllDomItemProviderTest.assertNotNull((Object)this.itemProvider.getRootAdapterFactory());
    }

    public void testIJavaWebServiceElementItemProvider() {
        IJavaWebServiceElementItemProvider javaItemProvider = (IJavaWebServiceElementItemProvider)this.itemProvider.createIJavaWebServiceElementAdapter();
        AllDomItemProviderTest.assertNotNull((Object)javaItemProvider);
        List propDescs = javaItemProvider.getPropertyDescriptors(null);
        AllDomItemProviderTest.assertNotNull((Object)propDescs);
        AllDomItemProviderTest.assertTrue((propDescs.size() > 0 ? 1 : 0) != 0);
        Mock javaWSElem = this.mock(IJavaWebServiceElement.class);
        javaWSElem.expects(this.once()).method("getName").will(this.returnValue("TestName"));
        AllDomItemProviderTest.assertNotNull((Object)javaItemProvider.getImage(new Object()));
        AllDomItemProviderTest.assertNotNull((Object)javaItemProvider.getText(javaWSElem.proxy()));
        AllDomItemProviderTest.assertNull((Object)javaItemProvider.getNameCategory());
    }

    public void testIServiceEndpointItemProvider() {
        IServiceEndpointInterfaceItemProvider seiItemProvider = (IServiceEndpointInterfaceItemProvider)this.itemProvider.createIServiceEndpointInterfaceAdapter();
        AllDomItemProviderTest.assertNotNull((Object)seiItemProvider);
        List propDescs = seiItemProvider.getPropertyDescriptors(null);
        AllDomItemProviderTest.assertNotNull((Object)propDescs);
        AllDomItemProviderTest.assertTrue((propDescs.size() > 0 ? 1 : 0) != 0);
        Mock sEIElem = this.mock(IServiceEndpointInterface.class);
        sEIElem.expects(this.once()).method("getName").will(this.returnValue("TestName"));
        AllDomItemProviderTest.assertNotNull((Object)seiItemProvider.getImage(new Object()));
        AllDomItemProviderTest.assertNotNull((Object)seiItemProvider.getText(sEIElem.proxy()));
        AllDomItemProviderTest.assertNotNull((Object)seiItemProvider.getChildrenFeatures(null));
        AllDomItemProviderTest.assertNotNull((Object)seiItemProvider.getNameCategory());
    }

    public void testIWebMethodItemProvider() {
        IWebMethodItemProvider methodItemProvider = (IWebMethodItemProvider)this.itemProvider.createIWebMethodAdapter();
        AllDomItemProviderTest.assertNotNull((Object)methodItemProvider);
        List propDescs = methodItemProvider.getPropertyDescriptors(null);
        AllDomItemProviderTest.assertNotNull((Object)propDescs);
        AllDomItemProviderTest.assertTrue((propDescs.size() > 0 ? 1 : 0) != 0);
        Mock wMElem = this.mock(IWebMethod.class);
        wMElem.expects(this.once()).method("getName").will(this.returnValue("TestName"));
        AllDomItemProviderTest.assertNotNull((Object)methodItemProvider.getImage(new Object()));
        AllDomItemProviderTest.assertNotNull((Object)methodItemProvider.getText(wMElem.proxy()));
        AllDomItemProviderTest.assertNotNull((Object)methodItemProvider.getChildrenFeatures(null));
        AllDomItemProviderTest.assertNotNull((Object)methodItemProvider.getNameCategory());
    }

    public void testIWebServiceItemProvider() {
        IWebServiceItemProvider wsItemProvider = (IWebServiceItemProvider)this.itemProvider.createIWebServiceAdapter();
        AllDomItemProviderTest.assertNotNull((Object)wsItemProvider);
        List propDescs = wsItemProvider.getPropertyDescriptors(null);
        AllDomItemProviderTest.assertNotNull((Object)propDescs);
        AllDomItemProviderTest.assertTrue((propDescs.size() > 0 ? 1 : 0) != 0);
        Mock wsElem = this.mock(IWebService.class);
        wsElem.expects(this.once()).method("getName").will(this.returnValue("TestName"));
        AllDomItemProviderTest.assertNotNull((Object)wsItemProvider.getImage(new Object()));
        AllDomItemProviderTest.assertNotNull((Object)wsItemProvider.getText(wsElem.proxy()));
        AllDomItemProviderTest.assertNotNull((Object)wsItemProvider.getNameCategory());
    }

    public void testIWebServiceProjectItemProvider() {
        IWebServiceProjectItemProvider wsProjItemProvider = (IWebServiceProjectItemProvider)this.itemProvider.createIWebServiceProjectAdapter();
        AllDomItemProviderTest.assertNotNull((Object)wsProjItemProvider);
        List propDescs = wsProjItemProvider.getPropertyDescriptors(null);
        AllDomItemProviderTest.assertNotNull((Object)propDescs);
        AllDomItemProviderTest.assertTrue((propDescs.size() > 0 ? 1 : 0) != 0);
        Mock wsProjElem = this.mock(IWebServiceProject.class);
        wsProjElem.expects(this.once()).method("getName").will(this.returnValue("TestName"));
        AllDomItemProviderTest.assertNotNull((Object)wsProjItemProvider.getImage(new Object()));
        AllDomItemProviderTest.assertNotNull((Object)wsProjItemProvider.getText(wsProjElem.proxy()));
        AllDomItemProviderTest.assertNotNull((Object)wsProjItemProvider.getChildrenFeatures(null));
    }

    public void testIWebMethodItemProviderGetImplementation() {
        IWebMethodItemProvider methodItemProvider = (IWebMethodItemProvider)this.itemProvider.createIWebMethodAdapter();
        AllDomItemProviderTest.assertNotNull((Object)methodItemProvider);
        Mock webParam1 = this.mock(IWebParam.class);
        webParam1.expects(this.atLeastOnce()).method("getName").will(this.returnValue("Param1"));
        webParam1.expects(this.atLeastOnce()).method("getTypeName").will(this.returnValue("boolean"));
        Mock webParam2 = this.mock(IWebParam.class);
        webParam2.expects(this.atLeastOnce()).method("getName").will(this.returnValue("return"));
        webParam2.expects(this.atLeastOnce()).method("getTypeName").will(this.returnValue("java.lang.String"));
        BasicEList webParams = new BasicEList();
        webParams.add((Object)((IWebParam)webParam1.proxy()));
        webParams.add((Object)((IWebParam)webParam2.proxy()));
        Mock webMethod = this.mock(IWebMethod.class);
        webMethod.expects(this.atLeastOnce()).method("getParameters").will(this.returnValue(webParams));
        webMethod.expects(this.atLeastOnce()).method("getImplementation").will(this.returnValue("testMethod(B)QString"));
        BasicEList adapters = new BasicEList();
        Mock adapter = this.mock(StateAdapter.class);
        adapter.stubs().method("isAdapterForType").will(this.returnValue(true));
        adapter.stubs().method("isChangeable").will(this.returnValue(false));
        adapters.add((Object)((StateAdapter)adapter.proxy()));
        webMethod.expects(this.atLeastOnce()).method("eAdapters").will(this.returnValue(adapters));
        ((IWebMethod)webMethod.proxy()).eAdapters();
        methodItemProvider.setTarget((Notifier)webMethod.proxy());
        List propDescs = methodItemProvider.getPropertyDescriptors(webMethod.proxy());
        AllDomItemProviderTest.assertNotNull((Object)propDescs);
        AllDomItemProviderTest.assertTrue((propDescs.size() > 0 ? 1 : 0) != 0);
        for (IItemPropertyDescriptor propDesc : propDescs) {
            if (!propDesc.getFeature(null).equals(DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__IMPLEMENTATION)) continue;
            AllDomItemProviderTest.assertEquals((String)((ItemPropertyDescriptor.PropertyValueWrapper)propDesc.getPropertyValue(webMethod.proxy())).getText(null), (String)"String testMethod(boolean)");
        }
    }

    public void testIWebParamItemProvider() {
        IWebParamItemProvider itemProvider = (IWebParamItemProvider)new DomItemProviderAdapterFactory().createIWebParamAdapter();
        Mock paramMock = this.mock(IWebParam.class);
        AllDomItemProviderTest.assertNotNull((Object)itemProvider.getImage(new Object()));
        paramMock.stubs().method("getName").will(this.returnValue("myParam"));
        paramMock.stubs().method("getTypeName").will(this.returnValue("java.util.List"));
        paramMock.stubs().method("getImplementation").will(this.returnValue("test"));
        paramMock.stubs().method("eContainer").will(this.returnValue(null));
        paramMock.stubs().method("eResource").will(this.returnValue(null));
        AllDomItemProviderTest.assertEquals((String)"myParam", (String)itemProvider.getText(paramMock.proxy()));
        AllDomItemProviderTest.assertNotNull((Object)itemProvider.getImage(paramMock.proxy()));
        AllDomItemProviderTest.assertNotNull((Object)itemProvider.getNameCategory());
        paramMock.stubs().method("getImplementation").will(this.returnValue("return"));
        AllDomItemProviderTest.assertNotNull((Object)itemProvider.getImage(paramMock.proxy()));
    }

    public void testIWebParamItemProviderForTypeName() {
        IItemPropertyDescriptor typeNamePropertyDescriptor = this.findWebParamItemPropertyDescriptor(DomPackage.Literals.IWEB_PARAM__TYPE_NAME);
        IWebParam webParam = DomFactory.eINSTANCE.createIWebParam();
        webParam.setHeader(true);
        webParam.setKind(WebParamKind.INOUT);
        webParam.setName("anyName");
        webParam.setPartName("anyPartName");
        webParam.setTargetNamespace("anyTargetNamespace");
        webParam.eSet((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TYPE_NAME, null);
        AllDomItemProviderTest.assertNull((String)"Unexpected value.", (Object)typeNamePropertyDescriptor.getPropertyValue((Object)webParam));
        Object propertyValueWrapper = null;
        webParam.eSet((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TYPE_NAME, (Object)"I");
        propertyValueWrapper = typeNamePropertyDescriptor.getPropertyValue((Object)webParam);
        AllDomItemProviderTest.assertEquals((String)"Unresolved value.", (Object)"int", (Object)((IItemPropertySource)propertyValueWrapper).getEditableValue(null));
        webParam.eSet((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TYPE_NAME, (Object)"[QString;");
        propertyValueWrapper = typeNamePropertyDescriptor.getPropertyValue((Object)webParam);
        AllDomItemProviderTest.assertEquals((String)"Unresolved value.", (Object)"String[]", (Object)((IItemPropertySource)propertyValueWrapper).getEditableValue(null));
    }

    private IItemPropertyDescriptor findWebParamItemPropertyDescriptor(EAttribute attribute) {
        IWebParamItemProvider itemProvider = (IWebParamItemProvider)new DomItemProviderAdapterFactory().createIWebParamAdapter();
        List descriptors = itemProvider.getPropertyDescriptors(null);
        for (IItemPropertyDescriptor descriptor : descriptors) {
            if (!descriptor.getFeature(null).equals(attribute)) continue;
            return descriptor;
        }
        return null;
    }

    public static interface StateAdapter
    extends IPropertyState,
    Adapter {
    }
}

