/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDElementAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDSchemaBuildingTools;
import org.w3c.dom.Text;

public class AddXSDElementCommand
extends BaseCommand {
    XSDComplexTypeDefinition xsdComplexTypeDefinition;
    XSDModelGroupDefinition xsdModelGroupDefinition;
    XSDModelGroup xsdModelGroup;
    XSDSchema xsdSchema;
    boolean isReference;
    private String nameToAdd;
    private int index = -1;
    private String addElementLocation;

    public AddXSDElementCommand() {
    }

    public AddXSDElementCommand(String label, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        super(label);
        this.xsdComplexTypeDefinition = xsdComplexTypeDefinition;
        this.xsdModelGroup = this.getModelGroup(xsdComplexTypeDefinition);
    }

    public AddXSDElementCommand(String label, XSDModelGroupDefinition xsdModelGroupDefinition) {
        super(label);
        this.xsdModelGroupDefinition = xsdModelGroupDefinition;
        this.xsdModelGroup = this.getModelGroup(xsdModelGroupDefinition);
    }

    public AddXSDElementCommand(String label, XSDModelGroup xsdModelGroup, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        super(label);
        this.xsdModelGroup = xsdModelGroup;
        this.xsdComplexTypeDefinition = xsdComplexTypeDefinition;
    }

    public AddXSDElementCommand(String label, XSDModelGroup xsdModelGroup) {
        super(label);
        this.xsdModelGroup = xsdModelGroup;
    }

    public AddXSDElementCommand(String label, XSDModelGroup xsdModelGroup, String ID, int index) {
        super(label);
        this.xsdModelGroup = xsdModelGroup;
        this.index = index;
        this.addElementLocation = ID;
    }

    public AddXSDElementCommand(String label, XSDSchema xsdSchema) {
        super(label);
        this.xsdSchema = xsdSchema;
    }

    public void setReference(boolean isReference) {
        this.isReference = isReference;
    }

    public void setNameToAdd(String name) {
        this.nameToAdd = name;
    }

    public void setAddElementLocation(String LocationType) {
        this.addElementLocation = LocationType;
    }

    protected int getInsertionIndex() {
        if (this.index < 0) {
            return -1;
        }
        if (this.addElementLocation.equals(AddXSDElementAction.BEFORE_SELECTED_ID)) {
            return this.index;
        }
        if (this.addElementLocation.equals(AddXSDElementAction.AFTER_SELECTED_ID)) {
            ++this.index;
            return this.index;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            if (this.xsdSchema != null) {
                this.beginRecording(this.xsdSchema.getElement());
                XSDElementDeclaration element = this.createGlobalXSDElementDeclaration();
                Text textNode = this.xsdSchema.getDocument().createTextNode("\n");
                this.xsdSchema.getElement().appendChild(textNode);
                this.xsdSchema.getContents().add((Object)element);
                this.addedXSDConcreteComponent = element;
            } else if (this.xsdModelGroupDefinition != null) {
                this.beginRecording(this.xsdModelGroupDefinition.getElement());
                if (this.xsdModelGroup == null) {
                    XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
                    XSDParticle particle = factory.createXSDParticle();
                    this.xsdModelGroup = factory.createXSDModelGroup();
                    this.xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
                    particle.setContent((XSDParticleContent)this.xsdModelGroup);
                    this.xsdModelGroupDefinition.setModelGroup(this.xsdModelGroup);
                }
                this.xsdSchema = this.xsdModelGroupDefinition.getSchema();
                if (!this.isReference) {
                    this.xsdModelGroup.getContents().add((Object)this.createXSDElementDeclarationForModelGroupDefinitions());
                } else {
                    this.xsdModelGroup.getContents().add((Object)this.createXSDElementReference());
                }
                this.formatChild(this.xsdModelGroupDefinition.getElement());
            } else if (this.xsdModelGroup != null && (this.xsdComplexTypeDefinition == null || this.xsdModelGroupDefinition == null)) {
                this.xsdSchema = this.xsdModelGroup.getSchema();
                this.beginRecording(this.xsdSchema.getElement());
                if (!this.isReference) {
                    this.index = this.getInsertionIndex();
                    if (this.index >= 0 && this.index < this.xsdModelGroup.getContents().size()) {
                        this.xsdModelGroup.getContents().add(this.index, (Object)this.createXSDElementDeclaration());
                    } else {
                        this.xsdModelGroup.getContents().add((Object)this.createXSDElementDeclaration());
                    }
                } else {
                    this.xsdModelGroup.getContents().add((Object)this.createXSDElementReference());
                }
                this.formatChild(this.xsdModelGroup.getElement());
            } else {
                this.xsdSchema = this.xsdComplexTypeDefinition.getSchema();
                this.beginRecording(this.xsdSchema.getElement());
                if (this.xsdModelGroup == null) {
                    XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
                    XSDParticle particle = factory.createXSDParticle();
                    this.xsdModelGroup = factory.createXSDModelGroup();
                    this.xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
                    particle.setContent((XSDParticleContent)this.xsdModelGroup);
                    this.xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)particle);
                }
                if (!this.isReference) {
                    this.xsdModelGroup.getContents().add((Object)this.createXSDElementDeclarationForComplexType());
                } else {
                    this.xsdModelGroup.getContents().add((Object)this.createXSDElementReference());
                }
                this.formatChild(this.xsdComplexTypeDefinition.getElement());
            }
            Object var3_9 = null;
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.endRecording();
            throw throwable;
        }
        this.endRecording();
    }

    protected XSDParticle createXSDElementDeclaration() {
        XSDSimpleTypeDefinition type = this.xsdModelGroup.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string");
        XSDElementDeclaration element = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        XSDConcreteComponent comp = this.xsdModelGroup.getContainer();
        ArrayList usedAttributeNames = new ArrayList();
        XSDCommonUIUtils.resetVisitedGroupsStack();
        usedAttributeNames.addAll(XSDCommonUIUtils.getChildElements(this.xsdModelGroup));
        while (comp != null) {
            if (comp instanceof XSDModelGroupDefinition) {
                usedAttributeNames.addAll(XSDCommonUIUtils.getAllAttributes((XSDModelGroupDefinition)comp));
                break;
            }
            if (comp instanceof XSDComplexTypeDefinition) {
                usedAttributeNames.addAll(XSDCommonUIUtils.getAllAttributes((XSDComplexTypeDefinition)comp));
                usedAttributeNames.addAll(XSDCommonUIUtils.getInheritedAttributes((XSDComplexTypeDefinition)comp));
                break;
            }
            comp = comp.getContainer();
        }
        element.setName(XSDCommonUIUtils.createUniqueElementName(this.nameToAdd == null ? "NewElement" : this.nameToAdd, usedAttributeNames));
        element.setTypeDefinition((XSDTypeDefinition)type);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent((XSDParticleContent)element);
        this.addedXSDConcreteComponent = element;
        return particle;
    }

    protected XSDParticle createXSDElementReference() {
        EList list = this.xsdModelGroup.getSchema().getElementDeclarations();
        XSDElementDeclaration referencedElement = null;
        if (list.size() > 0) {
            referencedElement = (XSDElementDeclaration)list.get(0);
        } else {
            referencedElement = this.createGlobalXSDElementDeclaration();
            Text textNode = this.xsdSchema.getDocument().createTextNode("\n");
            this.xsdSchema.getElement().appendChild(textNode);
            this.xsdSchema.getContents().add((Object)referencedElement);
        }
        XSDElementDeclaration element = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        element.setResolvedElementDeclaration(referencedElement);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent((XSDParticleContent)element);
        this.addedXSDConcreteComponent = element;
        return particle;
    }

    protected XSDParticle createXSDElementDeclarationForComplexType() {
        XSDSimpleTypeDefinition type = this.xsdModelGroup.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string");
        XSDElementDeclaration element = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        ArrayList usedAttributeNames = new ArrayList();
        usedAttributeNames.addAll(XSDCommonUIUtils.getAllAttributes(this.xsdComplexTypeDefinition));
        usedAttributeNames.addAll(XSDCommonUIUtils.getInheritedAttributes(this.xsdComplexTypeDefinition));
        element.setName(XSDCommonUIUtils.createUniqueElementName(this.nameToAdd == null ? "NewElement" : this.nameToAdd, usedAttributeNames));
        element.setTypeDefinition((XSDTypeDefinition)type);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent((XSDParticleContent)element);
        this.addedXSDConcreteComponent = element;
        return particle;
    }

    protected XSDParticle createXSDElementDeclarationForModelGroupDefinitions() {
        XSDSimpleTypeDefinition type = this.xsdModelGroup.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string");
        XSDElementDeclaration element = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        ArrayList usedAttributeNames = new ArrayList();
        usedAttributeNames.addAll(XSDCommonUIUtils.getAllAttributes(this.xsdModelGroupDefinition));
        element.setName(XSDCommonUIUtils.createUniqueElementName(this.nameToAdd == null ? "NewElement" : this.nameToAdd, usedAttributeNames));
        element.setTypeDefinition((XSDTypeDefinition)type);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent((XSDParticleContent)element);
        this.addedXSDConcreteComponent = element;
        return particle;
    }

    protected XSDElementDeclaration createGlobalXSDElementDeclaration() {
        AddXSDElementCommand.ensureSchemaElement(this.xsdSchema);
        XSDSimpleTypeDefinition type = this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string");
        XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
        XSDElementDeclaration element = factory.createXSDElementDeclaration();
        element.setName(XSDCommonUIUtils.createUniqueElementName(this.nameToAdd == null ? "NewElement" : this.nameToAdd, (List)this.xsdSchema.getElementDeclarations()));
        element.setTypeDefinition((XSDTypeDefinition)type);
        return element;
    }

    public XSDModelGroup getModelGroup(XSDModelGroupDefinition modelGroupDef) {
        return modelGroupDef.getModelGroup();
    }

    public XSDModelGroup getModelGroup(XSDComplexTypeDefinition cType) {
        XSDParticle particle = null;
        XSDComplexTypeContent xsdComplexTypeContent = cType.getContent();
        if (xsdComplexTypeContent instanceof XSDParticle) {
            particle = (XSDParticle)xsdComplexTypeContent;
        }
        if (particle == null) {
            return null;
        }
        XSDParticleContent particleContent = particle.getContent();
        XSDModelGroup group = null;
        if (particleContent instanceof XSDModelGroupDefinition) {
            group = ((XSDModelGroupDefinition)particleContent).getResolvedModelGroupDefinition().getModelGroup();
        } else if (particleContent instanceof XSDModelGroup) {
            group = (XSDModelGroup)particleContent;
        }
        if (group == null) {
            return null;
        }
        return group;
    }

    public XSDConcreteComponent getAddedComponent() {
        return super.getAddedComponent();
    }
}

