/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumLineBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ChromiumDebugPluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.ui.propertypages.JsLineBreakpointPage;
import org.eclipse.wst.jsdt.chromium.debug.ui.propertypages.Messages;
import org.eclipse.wst.jsdt.chromium.debug.ui.propertypages.ScriptFilePage;

public class BreakpointTechnicalInfoPage
extends PropertyPage {
    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        ChromiumLineBreakpoint breakpoint = this.getBreakpoint();
        Composite mainComposite = JsLineBreakpointPage.createComposite(parent, 1, 1);
        this.createTechnicalInfoControls(mainComposite, breakpoint);
        this.setValid(true);
        return mainComposite;
    }

    private void createTechnicalInfoControls(Composite parent, ChromiumLineBreakpoint breakpoint) {
        ArrayList<TargetInfo> list = new ArrayList<TargetInfo>();
        for (ConnectedTargetData connected : DebugTargetImpl.getAllConnectedTargetDatas()) {
            WorkspaceBridge workspaceRelations = connected.getWorkspaceRelations();
            WorkspaceBridge.BreakpointHandler breakpointHandler = workspaceRelations.getBreakpointHandler();
            Breakpoint sdkBreakpoint = breakpointHandler.getSdkBreakpoint(breakpoint);
            list.add(new TargetInfo(connected, sdkBreakpoint));
        }
        new Label(parent, 0).setText(Messages.BreakpointTechnicalInfoPage_CHOOSE_LAUNCH);
        String[] launchLabels = new String[list.size()];
        int i = 0;
        while (i < launchLabels.length) {
            TargetInfo targetInfo = (TargetInfo)list.get(i);
            DebugTargetImpl debugTarget = targetInfo.connectedTargetData.getDebugTarget();
            launchLabels[i] = debugTarget.getLaunch().getLaunchConfiguration().getName();
            ++i;
        }
        final Combo typesCombo = new Combo(parent, 8);
        typesCombo.setLayoutData((Object)new GridData(768));
        typesCombo.setFont(parent.getFont());
        typesCombo.setItems(launchLabels);
        if (launchLabels.length == 0) {
            return;
        }
        typesCombo.select(0);
        new Label(parent, 0);
        class BreakpointProperties {
            final Text text;
            private final /* synthetic */ List val$list;

            BreakpointProperties(Composite composite, List list) {
                this.val$list = list;
                Composite c = JsLineBreakpointPage.createComposite(composite, 2, 1);
                this.text = ScriptFilePage.createTextField(c, Messages.BreakpointTechnicalInfoPage_TARGET);
            }

            void fillIn(int pos) {
                String value;
                TargetInfo info = (TargetInfo)this.val$list.get(pos);
                if (info.sdkBreakpoint == null) {
                    value = Messages.BreakpointTechnicalInfoPage_NOT_SET;
                } else {
                    Breakpoint.Target target = info.sdkBreakpoint.getTarget();
                    value = (String)target.accept(ChromiumDebugPluginUtil.BREAKPOINT_TARGET_TO_STRING);
                }
                this.text.setText(value);
            }
        }
        final BreakpointProperties breakpointProperties = new BreakpointProperties(parent, list);
        breakpointProperties.fillIn(0);
        typesCombo.addSelectionListener(new SelectionListener(){
            {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = typesCombo.getSelectionIndex();
                breakpointProperties.fillIn(index);
            }
        });
    }

    private ChromiumLineBreakpoint getBreakpoint() {
        IAdapterManager manager = Platform.getAdapterManager();
        IAdaptable adaptable = this.getElement();
        ChromiumLineBreakpoint adapted = (ChromiumLineBreakpoint)manager.getAdapter((Object)adaptable, ChromiumLineBreakpoint.class);
        return adapted;
    }

    private static class TargetInfo {
        final ConnectedTargetData connectedTargetData;
        final Breakpoint sdkBreakpoint;

        TargetInfo(ConnectedTargetData connectedTargetData, Breakpoint sdkBreakpoint) {
            this.connectedTargetData = connectedTargetData;
            this.sdkBreakpoint = sdkBreakpoint;
        }
    }
}

