/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Random;
import junit.framework.Assert;
import org.eclipse.wst.jsdt.chromium.util.ByteToCharConverter;
import org.junit.Test;

public class ByteToCharConverterTest {
    private static final String[] INPUT_STRINGS = new String[]{"\u043a\u0430\u043f\u0438\u0431\u0430\u0440\u0430", "1\u04302\u04313\u04324\u04335\u04346\u04357", "\u0430_\u0431_\u0432_\u0433_\u0434_\u0435", "\u041c\u0438\u0441\u0441\u0438\u044f Google \u0441\u043e\u0441\u0442\u043e\u0438\u0442 \u0432 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0438\u0440\u043e\u0432\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438, \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0438 \u0435\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u0438 \u0438 \u043f\u043e\u043b\u044c\u0437\u044b \u0434\u043b\u044f \u0432\u0441\u0435\u0445."};

    @Test
    public void testConvertByVariousChunks() {
        Random random = new Random(0L);
        int i = 0;
        while (i < 20) {
            String[] stringArray = INPUT_STRINGS;
            int n = INPUT_STRINGS.length;
            int n2 = 0;
            while (n2 < n) {
                String input = stringArray[n2];
                this.convertByRandomSteps(input, random);
                ++n2;
            }
            ++i;
        }
    }

    private void convertByRandomSteps(String text, Random random) {
        Charset charset = Charset.forName("UTF-8");
        ByteToCharConverter converter = new ByteToCharConverter(charset);
        byte[] bytes = text.getBytes(charset);
        int pos = 0;
        StringBuilder builder = new StringBuilder();
        while (pos < bytes.length) {
            int stepSize = random.nextInt(10);
            stepSize = Math.min(stepSize, bytes.length - pos);
            CharBuffer output = converter.convert(ByteBuffer.wrap(bytes, pos, stepSize));
            while (output.hasRemaining()) {
                builder.append(output.get());
            }
            pos += stepSize;
        }
        Assert.assertEquals((String)text, (String)builder.toString());
    }
}

