/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

public class StrBuffer
implements CharSequence {
    private int numChar;
    private char[] myBuf;

    public StrBuffer() {
        this(80);
    }

    public StrBuffer(int length) {
        this.myBuf = new char[length];
        this.numChar = 0;
    }

    public void reset() {
        this.numChar = 0;
    }

    private void increaseCapacity(int minStorage) {
        int newStorage = this.myBuf.length * 2 + 5;
        if (newStorage < minStorage) {
            newStorage = minStorage;
        }
        char[] newBuf = new char[newStorage];
        System.arraycopy(this.myBuf, 0, newBuf, 0, this.numChar);
        this.myBuf = newBuf;
    }

    public StrBuffer append(String str) {
        int strlen = str.length();
        int newLength = this.numChar + strlen;
        if (newLength > this.myBuf.length) {
            this.increaseCapacity(newLength);
        }
        str.getChars(0, strlen, this.myBuf, this.numChar);
        this.numChar = newLength;
        return this;
    }

    public StrBuffer append(char[] chars, int start, int length) {
        int newLength = this.numChar + length;
        if (newLength > this.myBuf.length) {
            this.increaseCapacity(newLength);
        }
        System.arraycopy(chars, start, this.myBuf, this.numChar, length);
        this.numChar = newLength;
        return this;
    }

    @Override
    public int length() {
        return this.numChar;
    }

    @Override
    public String toString() {
        return new String(this.myBuf, 0, this.numChar);
    }

    @Override
    public char charAt(int index) {
        return this.myBuf[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new String(this.myBuf, start, end);
    }
}

