/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;

public class Trace {
    public static final byte CONFIG = 0;
    public static final byte WARNING = 1;
    public static final byte SEVERE = 2;
    public static final byte FINEST = 3;
    public static final byte FINER = 4;
    private static final String[] levelNames = new String[]{"CONFIG   ", "WARNING  ", "SEVERE   ", "FINER    ", "FINEST   "};
    private static final String spacer = "                                   ";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm.ss.SSS");
    protected static int pluginLength = -1;

    private Trace() {
    }

    public static void trace(byte level, String s) {
        Trace.trace(level, s, null);
    }

    public static void trace(byte level, String s, Throwable t) {
        if (!TomcatPlugin.getInstance().isDebugging()) {
            return;
        }
        Trace.trace("org.eclipse.jst.server.tomcat.core", level, s, t);
    }

    private static void trace(String pluginId, int level, String s, Throwable t) {
        if (pluginId == null || s == null) {
            return;
        }
        if (!TomcatPlugin.getInstance().isDebugging()) {
            return;
        }
        StringBuffer sb = new StringBuffer(pluginId);
        if (pluginId.length() > pluginLength) {
            pluginLength = pluginId.length();
        } else if (pluginId.length() < pluginLength) {
            sb.append(spacer.substring(0, pluginLength - pluginId.length()));
        }
        sb.append(" ");
        sb.append(levelNames[level]);
        sb.append(" ");
        sb.append(sdf.format(new Date()));
        sb.append(" ");
        sb.append(s);
        System.out.println(sb.toString());
        if (t != null) {
            t.printStackTrace();
        }
    }

    public static boolean isTraceEnabled() {
        return TomcatPlugin.getInstance().isDebugging();
    }
}

