/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;

public class ContentTypeSpecs {
    String[] fFilenames = new String[0];
    String[] fExtensions = new String[0];

    public static ContentTypeSpecs createFor(String contentTypeId) {
        return ContentTypeSpecs.createFor(new IContentType[]{Platform.getContentTypeManager().getContentType(contentTypeId)});
    }

    public static ContentTypeSpecs createFor(IContentType[] contentTypes) {
        ArrayList<String> filenameExtensions = new ArrayList<String>();
        HashSet<String> filenames = new HashSet<String>();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType baseContentType = iContentTypeArray[n2];
            Object[] baseExtensions = baseContentType.getFileSpecs(8);
            int i = 0;
            while (i < baseExtensions.length) {
                filenameExtensions.add(baseExtensions[i]);
                ++i;
            }
            String[] names = baseContentType.getFileSpecs(4);
            int j = 0;
            while (j < names.length) {
                filenames.add(names[j]);
                ++j;
            }
            Arrays.sort(baseExtensions);
            IContentType[] allContentTypes = Platform.getContentTypeManager().getAllContentTypes();
            int i2 = 0;
            int length = allContentTypes.length;
            while (i2 < length) {
                if (!baseContentType.equals(allContentTypes[i2]) && allContentTypes[i2].isKindOf(baseContentType)) {
                    String[] fileExtension = allContentTypes[i2].getFileSpecs(8);
                    int j2 = 0;
                    while (j2 < fileExtension.length) {
                        if (!filenameExtensions.contains(fileExtension[j2])) {
                            filenameExtensions.add(fileExtension[j2]);
                        }
                        ++j2;
                    }
                    names = allContentTypes[i2].getFileSpecs(4);
                    j2 = 0;
                    while (j2 < names.length) {
                        filenames.add(names[j2]);
                        ++j2;
                    }
                }
                ++i2;
            }
            ++n2;
        }
        String[] stringExtensions = filenameExtensions.toArray(new String[filenameExtensions.size()]);
        return new ContentTypeSpecs(filenames.toArray(new String[filenames.size()]), stringExtensions);
    }

    private ContentTypeSpecs(String[] fileNames, String[] extensions) {
        this.fFilenames = fileNames;
        this.fExtensions = extensions;
        Arrays.sort(fileNames);
    }

    public boolean matches(String filename) {
        if (Arrays.binarySearch(this.fFilenames, filename) >= 0) {
            return true;
        }
        int i = 0;
        while (i < this.fExtensions.length) {
            if (filename.length() > this.fExtensions[i].length() + 1 && filename.charAt(filename.length() - this.fExtensions[i].length() - 1) == '.' && filename.endsWith(this.fExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addFilename(String filename) {
        ArrayList<String> combinedList = new ArrayList<String>(this.fFilenames.length + 1);
        int i = 0;
        while (i < this.fFilenames.length) {
            combinedList.add(this.fFilenames[i]);
            ++i;
        }
        combinedList.add(filename);
        Object[] combinedArray = combinedList.toArray(new String[combinedList.size()]);
        Arrays.sort(combinedArray);
        this.fFilenames = combinedArray;
    }

    public void addFilenameExtension(String extension) {
        ArrayList<String> combinedList = new ArrayList<String>(this.fExtensions.length + 1);
        int i = 0;
        while (i < this.fExtensions.length) {
            combinedList.add(this.fExtensions[i]);
            ++i;
        }
        combinedList.add(extension);
        String[] combinedArray = combinedList.toArray(new String[combinedList.size()]);
        this.fExtensions = combinedArray;
    }
}

