/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceSEIRestrictionsRule
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebService.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof ClassDeclaration)) continue;
            Collection annotationMirrors = declaration.getAnnotationMirrors();
            for (AnnotationMirror mirror : annotationMirrors) {
                AnnotationValue endpointInterface = AnnotationUtils.getAnnotationValue((AnnotationMirror)mirror, (String)"endpointInterface");
                if (endpointInterface == null) continue;
                AnnotationValue name = AnnotationUtils.getAnnotationValue((AnnotationMirror)mirror, (String)"name");
                if (name != null) {
                    this.printFixableError(name.getPosition(), JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_NAME_ATTRIBUTE);
                }
                this.checkRestrictions((ClassDeclaration)declaration, endpointInterface);
                this.checkJSR181Annotations((ClassDeclaration)declaration);
            }
        }
    }

    private void checkRestrictions(ClassDeclaration classDeclaration, AnnotationValue endpointInterface) {
        String sei = endpointInterface.getValue().toString();
        if (JDTUtils.validateJavaTypeName(sei).getSeverity() == 4) {
            return;
        }
        TypeDeclaration typeDeclaration = this.environment.getTypeDeclaration(sei);
        if (typeDeclaration != null) {
            AnnotationMirror annotationMirror;
            if (!(typeDeclaration instanceof InterfaceDeclaration) || typeDeclaration instanceof AnnotationTypeDeclaration) {
                this.printError(endpointInterface.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NOT_INTERFACE, (Object)sei));
                return;
            }
            if (typeDeclaration.getDeclaringType() != null) {
                this.printError(endpointInterface.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NOT_OUTER, (Object)sei));
            }
            if ((annotationMirror = AnnotationUtils.getAnnotation((Declaration)typeDeclaration, WebService.class)) == null) {
                this.printError(endpointInterface.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NOT_ANNOTATED, (Object)sei));
            }
            if (!typeDeclaration.getModifiers().contains(Modifier.PUBLIC)) {
                this.printError(endpointInterface.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NOT_PUBLIC, (Object)sei));
            }
            if (!classDeclaration.getSuperinterfaces().contains(typeDeclaration)) {
                Collection seiMethods = typeDeclaration.getMethods();
                Collection<MethodDeclaration> implMethods = this.getAllMethods(classDeclaration);
                for (MethodDeclaration seiMethod : seiMethods) {
                    boolean implemented = false;
                    for (MethodDeclaration implMethod : implMethods) {
                        if (!AnnotationUtils.compareMethods((MethodDeclaration)seiMethod, (MethodDeclaration)implMethod)) continue;
                        if (!implMethod.getModifiers().contains(Modifier.PUBLIC)) {
                            this.printFixableError(implMethod.getPosition(), JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_REDUCED_VISIBILITY);
                        }
                        if (!implMethod.getReturnType().equals((Object)seiMethod.getReturnType())) {
                            this.printFixableError(implMethod.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_INCOMPATIBLE_RETURN_TYPE, (Object)this.getImplementsMessage(typeDeclaration, seiMethod)), "", JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_INCOMPATIBLE_RETURN_TYPE);
                        }
                        if (implMethod.getThrownTypes().size() != seiMethod.getThrownTypes().size() || !implMethod.getThrownTypes().containsAll(seiMethod.getThrownTypes())) {
                            this.printError(implMethod.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_INCOMPATIBLE_EXCEPTIONS, (Object)implMethod.getSimpleName(), (Object)sei));
                        }
                        implemented = true;
                        break;
                    }
                    if (implemented) continue;
                    this.printFixableError(endpointInterface.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_MUST_IMPLEMENT, (Object)this.getImplementsMessage(typeDeclaration, seiMethod)), "", JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_MUST_IMPLEMENT);
                }
            }
        } else {
            this.printError(endpointInterface.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NOT_FOUND, (Object)sei));
        }
    }

    private Collection<MethodDeclaration> getAllMethods(ClassDeclaration classDeclaration) {
        ArrayList<MethodDeclaration> allMethods = new ArrayList<MethodDeclaration>();
        this.collectAllMethodDeclarations(classDeclaration, allMethods);
        return allMethods;
    }

    private void collectAllMethodDeclarations(ClassDeclaration classDeclaration, Collection<MethodDeclaration> methods) {
        if (classDeclaration != null) {
            methods.addAll(classDeclaration.getMethods());
            ClassType classType = classDeclaration.getSuperclass();
            if (classType != null && classType.getDeclaration() != null) {
                this.collectAllMethodDeclarations(classType.getDeclaration(), methods);
            }
        }
    }

    private String getImplementsMessage(TypeDeclaration typeDeclaration, MethodDeclaration seiMethod) {
        StringBuilder message = new StringBuilder(typeDeclaration.getSimpleName());
        message.append(".");
        message.append(seiMethod.getSimpleName());
        message.append("(");
        Collection parameters = seiMethod.getParameters();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            ParameterDeclaration parameterDeclaration = (ParameterDeclaration)iter.next();
            String typeMirror = this.environment.getTypeUtils().getErasure(parameterDeclaration.getType()).toString();
            message.append(typeMirror.substring(typeMirror.lastIndexOf(".") + 1));
            if (!iter.hasNext()) continue;
            message.append(", ");
        }
        message.append(")");
        return message.toString();
    }

    private void checkJSR181Annotations(ClassDeclaration classDeclaration) {
        AnnotationMirror soapBinding = AnnotationUtils.getAnnotation((Declaration)classDeclaration, SOAPBinding.class);
        if (soapBinding != null) {
            this.printFixableError(soapBinding.getPosition(), JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_SOAPBINDING);
        }
        Collection implMethods = classDeclaration.getMethods();
        for (MethodDeclaration methodDeclaration : implMethods) {
            AnnotationMirror webResult;
            AnnotationMirror webMethod;
            AnnotationMirror oneway;
            AnnotationMirror msoapBinding = AnnotationUtils.getAnnotation((Declaration)methodDeclaration, SOAPBinding.class);
            if (msoapBinding != null) {
                this.printFixableError(msoapBinding.getPosition(), JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_SOAPBINDING);
            }
            if ((oneway = AnnotationUtils.getAnnotation((Declaration)methodDeclaration, Oneway.class)) != null) {
                this.printFixableError(oneway.getPosition(), JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_ONEWAY);
            }
            if ((webMethod = AnnotationUtils.getAnnotation((Declaration)methodDeclaration, WebMethod.class)) != null) {
                this.printFixableError(webMethod.getPosition(), JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_WEBMETHODS);
            }
            if ((webResult = AnnotationUtils.getAnnotation((Declaration)methodDeclaration, WebResult.class)) != null) {
                this.printFixableError(webResult.getPosition(), JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_WEBRESULT);
            }
            Collection parameters = methodDeclaration.getParameters();
            for (ParameterDeclaration parameterDeclaration : parameters) {
                AnnotationMirror webParam = AnnotationUtils.getAnnotation((Declaration)parameterDeclaration, WebParam.class);
                if (webParam == null) continue;
                this.printFixableError(webParam.getPosition(), JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_WEBPARAM);
            }
        }
    }
}

