/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.ranges.RangeException;

public class RangeImpl
implements Range {
    private Node endContainer = null;
    private int endOffset = 0;
    private Node startContainer = null;
    private int startOffset = 0;

    protected RangeImpl() {
    }

    protected RangeImpl(RangeImpl that) {
        if (that != null) {
            this.startContainer = that.startContainer;
            this.startOffset = that.startOffset;
            this.endContainer = that.endContainer;
            this.endOffset = that.endOffset;
        }
    }

    @Override
    public DocumentFragment cloneContents() throws DOMException {
        return null;
    }

    @Override
    public Range cloneRange() throws DOMException {
        return new RangeImpl(this);
    }

    @Override
    public void collapse(boolean toStart) throws DOMException {
        if (toStart) {
            this.endContainer = this.startContainer;
            this.endOffset = this.startOffset;
        } else {
            this.startContainer = this.endContainer;
            this.startOffset = this.endOffset;
        }
    }

    @Override
    public short compareBoundaryPoints(short how, Range sourceRange) throws DOMException {
        if (sourceRange == null) {
            return 0;
        }
        Node container1 = null;
        int offset1 = 0;
        Node container2 = null;
        int offset2 = 0;
        switch (how) {
            case 0: {
                container1 = this.startContainer;
                offset1 = this.startOffset;
                container2 = sourceRange.getStartContainer();
                offset2 = sourceRange.getStartOffset();
                break;
            }
            case 1: {
                container1 = this.startContainer;
                offset1 = this.startOffset;
                container2 = sourceRange.getEndContainer();
                offset2 = sourceRange.getEndOffset();
                break;
            }
            case 2: {
                container1 = this.endContainer;
                offset1 = this.endOffset;
                container2 = sourceRange.getEndContainer();
                offset2 = sourceRange.getEndOffset();
                break;
            }
            case 3: {
                container1 = this.endContainer;
                offset1 = this.endOffset;
                container2 = sourceRange.getStartContainer();
                offset2 = sourceRange.getStartOffset();
                break;
            }
            default: {
                return 0;
            }
        }
        return this.comparePoints(container1, offset1, container2, offset2);
    }

    protected short comparePoints(Node container1, int offset1, Node container2, int offset2) {
        if (container1 == null || container2 == null) {
            return 0;
        }
        if (container1 == container2) {
            if (offset1 > offset2) {
                return 1;
            }
            if (offset1 < offset2) {
                return -1;
            }
            return 0;
        }
        IDOMNode node1 = null;
        if (container1.hasChildNodes()) {
            Node child = container1.getFirstChild();
            int i = 0;
            while (i < offset1) {
                Node next = child.getNextSibling();
                if (next == null) break;
                child = next;
                ++i;
            }
            node1 = (IDOMNode)child;
            offset1 = 0;
        } else {
            node1 = (IDOMNode)container1;
        }
        int nodeOffset1 = node1.getStartOffset();
        IDOMNode node2 = null;
        if (container2.hasChildNodes()) {
            Node child = container2.getFirstChild();
            int i = 0;
            while (i < offset2) {
                Node next = child.getNextSibling();
                if (next == null) break;
                child = next;
                ++i;
            }
            node2 = (IDOMNode)child;
            offset2 = 0;
        } else {
            node2 = (IDOMNode)container2;
        }
        int nodeOffset2 = node2.getStartOffset();
        if (nodeOffset1 > nodeOffset2) {
            return 1;
        }
        if (nodeOffset1 < nodeOffset2) {
            return -1;
        }
        if (offset1 > offset2) {
            return 1;
        }
        if (offset1 < offset2) {
            return -1;
        }
        return 0;
    }

    @Override
    public void deleteContents() throws DOMException {
    }

    @Override
    public void detach() throws DOMException {
        this.startContainer = null;
        this.startOffset = 0;
        this.endContainer = null;
        this.endOffset = 0;
    }

    @Override
    public DocumentFragment extractContents() throws DOMException {
        return null;
    }

    @Override
    public boolean getCollapsed() throws DOMException {
        return this.startContainer == this.endContainer && this.startOffset == this.endOffset;
    }

    @Override
    public Node getCommonAncestorContainer() throws DOMException {
        if (this.startContainer == null) {
            return null;
        }
        return ((NodeImpl)this.startContainer).getCommonAncestor(this.endContainer);
    }

    @Override
    public Node getEndContainer() throws DOMException {
        return this.endContainer;
    }

    @Override
    public int getEndOffset() throws DOMException {
        return this.endOffset;
    }

    @Override
    public Node getStartContainer() throws DOMException {
        return this.startContainer;
    }

    @Override
    public int getStartOffset() throws DOMException {
        return this.startOffset;
    }

    @Override
    public void insertNode(Node newNode) throws RangeException, DOMException {
    }

    @Override
    public void selectNode(Node refNode) throws RangeException, DOMException {
        if (refNode == null) {
            return;
        }
        Node parent = refNode.getParentNode();
        if (parent == null) {
            return;
        }
        int index = ((NodeImpl)refNode).getIndex();
        if (index < 0) {
            return;
        }
        this.setStart(parent, index);
        this.setEnd(parent, index + 1);
    }

    @Override
    public void selectNodeContents(Node refNode) throws RangeException, DOMException {
        if (refNode == null) {
            return;
        }
        if (refNode.getNodeType() == 3) {
            Text text = (Text)refNode;
            this.setStart(refNode, 0);
            this.setEnd(refNode, text.getLength());
        } else {
            NodeList childNodes = refNode.getChildNodes();
            int length = childNodes != null ? childNodes.getLength() : 0;
            this.setStart(refNode, 0);
            this.setEnd(refNode, length);
        }
    }

    @Override
    public void setEnd(Node refNode, int offset) throws RangeException, DOMException {
        this.endContainer = refNode;
        this.endOffset = offset;
    }

    @Override
    public void setEndAfter(Node refNode) throws RangeException, DOMException {
        if (refNode == null) {
            return;
        }
        Node parent = refNode.getParentNode();
        if (parent == null) {
            return;
        }
        int index = ((NodeImpl)refNode).getIndex();
        if (index < 0) {
            return;
        }
        this.setEnd(parent, index + 1);
    }

    @Override
    public void setEndBefore(Node refNode) throws RangeException, DOMException {
        if (refNode == null) {
            return;
        }
        Node parent = refNode.getParentNode();
        if (parent == null) {
            return;
        }
        int index = ((NodeImpl)refNode).getIndex();
        if (index < 0) {
            return;
        }
        this.setEnd(parent, index);
    }

    @Override
    public void setStart(Node refNode, int offset) throws RangeException, DOMException {
        this.startContainer = refNode;
        this.startOffset = offset;
    }

    @Override
    public void setStartAfter(Node refNode) throws RangeException, DOMException {
        if (refNode == null) {
            return;
        }
        Node parent = refNode.getParentNode();
        if (parent == null) {
            return;
        }
        int index = ((NodeImpl)refNode).getIndex();
        if (index < 0) {
            return;
        }
        this.setStart(parent, index + 1);
    }

    @Override
    public void setStartBefore(Node refNode) throws RangeException, DOMException {
        if (refNode == null) {
            return;
        }
        Node parent = refNode.getParentNode();
        if (parent == null) {
            return;
        }
        int index = ((NodeImpl)refNode).getIndex();
        if (index < 0) {
            return;
        }
        this.setStart(parent, index);
    }

    @Override
    public void surroundContents(Node newParent) throws RangeException, DOMException {
    }
}

