/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.emf.workbench.nature.EMFNature;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class JavaMofReflectionCommand
extends AbstractDataModelOperation {
    public static String LABEL = "JavaMofReflectionCommand";
    public static String DESCRIPTION = "reflection for a given class";
    public static String OK_MESSAGE = "The model has been built ";
    private static String JAVA_EXTENSION = ".java";
    private static String CLASS_EXTENSION = ".class";
    private String clientProject;
    private JavaHelpers javaClass;
    private String qname;
    private String proxyBean;

    public JavaHelpers getJavaClass() {
        return this.javaClass;
    }

    private void processQName() {
        this.qname = this.proxyBean;
        if (this.qname.toLowerCase().endsWith(JAVA_EXTENSION)) {
            this.qname = this.qname.substring(0, this.qname.length() - 5);
        }
        if (this.qname.toLowerCase().endsWith(CLASS_EXTENSION)) {
            this.qname = this.qname.substring(0, this.qname.length() - 6);
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        IProject clientIProject = (IProject)ResourceUtils.findResource((String)this.clientProject);
        this.processQName();
        if (this.clientProject == null || this.qname == null) {
            return StatusUtils.warningStatus((String)ConsumptionMessages.MSG_WARN_UNABLE_TO_FIND_PROXY);
        }
        try {
            EMFNature nature = JemProjectUtilities.getJEM_EMF_Nature((IProject)clientIProject, (boolean)true);
            this.javaClass = JavaRefFactory.eINSTANCE.reflectType(this.qname, nature.getResourceSet());
        }
        catch (CoreException coreException) {}
        return status;
    }

    public void setProxyBean(String proxyBean) {
        this.proxyBean = proxyBean;
    }

    public void setClientProject(String clientProject) {
        this.clientProject = clientProject;
    }
}

