/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandContext;

public abstract class AbstractThreadLocalCommandContext<E extends CommandContext>
implements CommandContext {
    protected final ThreadLocal<E> threadLocal;
    protected final E defaultCommandContext;

    protected AbstractThreadLocalCommandContext(E defaultCommandContext) {
        if (defaultCommandContext == null) {
            throw new NullPointerException();
        }
        this.defaultCommandContext = defaultCommandContext;
        this.threadLocal = this.buildThreadLocal();
    }

    protected ThreadLocal<E> buildThreadLocal() {
        return new ThreadLocal();
    }

    @Override
    public void execute(Command command) {
        this.getThreadLocalCommandContext().execute(command);
    }

    protected E getThreadLocalCommandContext() {
        CommandContext context = (CommandContext)this.threadLocal.get();
        return (E)(context != null ? context : this.defaultCommandContext);
    }

    public void set(E commandContext) {
        this.threadLocal.set(commandContext);
    }

    public String toString() {
        return String.valueOf('[') + this.getThreadLocalCommandContext().toString() + ']';
    }
}

