/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.HistoryPageCompareEditorInput;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareMessages;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaElementHistoryPageSource;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaHistoryActionImpl;

class JavaCompareWithEditionActionImpl
extends JavaHistoryActionImpl {
    private static boolean USE_MODAL_COMPARE = false;

    JavaCompareWithEditionActionImpl() {
        super(false);
    }

    @Override
    public void run(ISelection selection) {
        IMember input = this.getEditionElement(selection);
        if (input == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)CompareMessages.CompareWithHistory_title, (String)CompareMessages.CompareWithHistory_invalidSelectionMessage);
            return;
        }
        JavaElementHistoryPageSource pageSource = JavaElementHistoryPageSource.getInstance();
        IFile file = pageSource.getFile(input);
        if (file == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)CompareMessages.CompareWithHistory_title, (String)CompareMessages.CompareWithHistory_internalErrorMessage);
            return;
        }
        if (USE_MODAL_COMPARE) {
            CompareConfiguration cc = new CompareConfiguration();
            cc.setLeftEditable(false);
            cc.setRightEditable(false);
            HistoryPageCompareEditorInput ci = new HistoryPageCompareEditorInput(cc, (IHistoryPageSource)pageSource, (Object)input);
            ci.setTitle(CompareMessages.JavaCompareWithEditionActionImpl_0);
            ci.setHelpContextId("org.eclipse.wst.jsdt.ui.compare_element_with_history_dialog_context");
            CompareUI.openCompareDialog((CompareEditorInput)ci);
        } else {
            TeamUI.showHistoryFor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (Object)input, (IHistoryPageSource)pageSource);
        }
    }
}

