/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.exception;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.exception.CompositeException;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

public class CompositeExceptionTests
extends TestCase {
    public CompositeExceptionTests(String name) {
        super(name);
    }

    public void testGetException() {
        NullPointerException npe = new NullPointerException();
        IllegalArgumentException iae = new IllegalArgumentException();
        CompositeException ex = new CompositeException(new Throwable[]{npe, iae});
        Iterable exceptions = ex.getExceptions();
        CompositeExceptionTests.assertEquals((int)2, (int)IterableTools.size((Iterable)exceptions));
        CompositeExceptionTests.assertTrue((boolean)IterableTools.contains((Iterable)exceptions, (Object)npe));
        CompositeExceptionTests.assertTrue((boolean)IterableTools.contains((Iterable)exceptions, (Object)iae));
    }

    public void testGetMessage() {
        NullPointerException npe = new NullPointerException();
        IllegalArgumentException iae = new IllegalArgumentException();
        CompositeException ex = new CompositeException(new Throwable[]{npe, iae});
        CompositeExceptionTests.assertTrue((boolean)ex.getMessage().contains("NullPointerException"));
        CompositeExceptionTests.assertTrue((boolean)ex.getMessage().contains("IllegalArgumentException"));
    }

    public void testToString() {
        CompositeException ex = new CompositeException(new Throwable[0]);
        CompositeExceptionTests.assertNotNull((Object)ex.toString());
    }
}

