/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.cm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.internal.managedobject.IManagedObject;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.facelet.core.internal.cm.ElementCMAdapter;
import org.eclipse.jst.jsf.facelet.core.internal.cm.FaceletDocumentFactory;
import org.eclipse.jst.jsf.facelet.core.internal.cm.TagInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamespace;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamespaceCMAdapter
implements CMNamedNodeMap,
CMDocument,
IManagedObject {
    private final Namespace _ns;
    private final Map<String, ElementCMAdapter> _elements;
    private final FaceletDocumentFactory _factory;
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);

    public NamespaceCMAdapter(Namespace ns, IProject project) {
        this._ns = ns;
        this._elements = new HashMap<String, ElementCMAdapter>();
        this._factory = new FaceletDocumentFactory(project);
    }

    public int getLength() {
        if (this._ns.hasViewElements()) {
            return this._ns.getViewElements().size();
        }
        return 0;
    }

    public CMNode getNamedItem(String name) {
        ITagElement tagElement;
        ElementCMAdapter element;
        String[] splitName;
        String localname = name;
        if (name != null && name.indexOf(58) > -1 && (splitName = name.split(":")).length == 2) {
            localname = splitName[1];
        }
        if ((element = this._elements.get(localname)) == null && (tagElement = this._ns.getViewElement(localname)) != null) {
            TagInfo tagInfo = this._factory.getOrCreateExtraTagInfo(this._ns.getNSUri());
            element = new ElementCMAdapter(tagElement, tagInfo);
            this._elements.put(localname, element);
        }
        return element;
    }

    public CMNode item(int index) {
        if (this._ns.hasViewElements() && index >= 0 && index < this._ns.getViewElements().size()) {
            Iterator<?> it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                ElementCMAdapter element;
                ITagElement tagElement = (ITagElement)it.next();
                if (i == index && tagElement != null && (element = this._elements.get(tagElement.getName())) == null) {
                    element = new ElementCMAdapter(tagElement, this._factory.getOrCreateExtraTagInfo(this._ns.getNSUri()));
                    this._elements.put(tagElement.getName(), element);
                    return element;
                }
                ++i;
            }
        }
        return null;
    }

    public Iterator<?> iterator() {
        return new WrappingIterator(this._ns.getViewElements());
    }

    public CMNamedNodeMap getElements() {
        return this;
    }

    public CMNamedNodeMap getEntities() {
        return null;
    }

    public CMNamespace getNamespace() {
        return new CMNamespaceImpl(this._ns.getNSUri());
    }

    public String getNodeName() {
        return this.getNamespace().getURI();
    }

    public int getNodeType() {
        return 4;
    }

    public Object getProperty(String propertyName) {
        return null;
    }

    public boolean supports(String propertyName) {
        return false;
    }

    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            this._elements.clear();
        }
    }

    public void checkpoint() {
    }

    public void destroy() {
    }

    public boolean isDisposed() {
        return this._isDisposed.get();
    }

    private static class CMNamespaceImpl
    implements CMNamespace {
        private final String _uri;

        CMNamespaceImpl(String uri) {
            this._uri = uri;
        }

        public String getPrefix() {
            return null;
        }

        public String getURI() {
            return this._uri;
        }

        public String getNodeName() {
            return this.getURI();
        }

        public int getNodeType() {
            return 8;
        }

        public Object getProperty(String propertyName) {
            return null;
        }

        public boolean supports(String propertyName) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrappingIterator
    implements Iterator<CMNode> {
        final Iterator _viewElementIterator;

        public WrappingIterator(Collection viewElements) {
            this._viewElementIterator = viewElements.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._viewElementIterator.hasNext();
        }

        @Override
        public CMNode next() {
            ITagElement nextElement = (ITagElement)this._viewElementIterator.next();
            CMNode node = NamespaceCMAdapter.this.getNamedItem(nextElement.getName());
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("");
        }
    }
}

