/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;

public final class JavaStandardBeanProxyConstants {
    public static final Object REGISTRY_KEY = new Object();
    final IBeanTypeProxy fCollectionType;
    final IBeanTypeProxy fListType;
    final IBeanTypeProxy fIteratorType;
    final IBeanTypeProxy fListIteratorType;
    final IBeanTypeProxy fEnumerationType;
    final IBeanTypeProxy fSystemType;
    final IBeanTypeProxy fStringType;
    IMethodProxy fCollectionAdd;
    IMethodProxy fCollectionAddAll;
    IMethodProxy fCollectionClear;
    IMethodProxy fCollectionContains;
    IMethodProxy fCollectionContainsAll;
    IMethodProxy fCollectionIsEmpty;
    IMethodProxy fCollectionIterator;
    IMethodProxy fCollectionRemove;
    IMethodProxy fCollectionRemoveAll;
    IMethodProxy fCollectionRetainAll;
    IMethodProxy fCollectionSize;
    IMethodProxy fCollectionToArray;
    IMethodProxy fCollectionToArrayWithArray;
    IMethodProxy fListAddWithInt;
    IMethodProxy fListAddAllWithInt;
    IMethodProxy fListGet;
    IMethodProxy fListIndexOf;
    IMethodProxy fListLastIndexOf;
    IMethodProxy fListListIterator;
    IMethodProxy fListListIteratorWithInt;
    IMethodProxy fListRemoveInt;
    IMethodProxy fListSet;
    IMethodProxy fListSubList;
    IMethodProxy fIteratorHasNext;
    IMethodProxy fIteratorNext;
    IMethodProxy fIteratorRemove;
    IMethodProxy fListIteratorAdd;
    IMethodProxy fListIteratorHasPrevious;
    IMethodProxy fListIteratorNextIndex;
    IMethodProxy fListIteratorPrevious;
    IMethodProxy fListIteratorPreviousIndex;
    IMethodProxy fListIteratorRemove;
    IMethodProxy fListIteratorSet;
    IMethodProxy fEnumerationHasMoreElements;
    IMethodProxy fEnumerationNextElement;
    IMethodProxy fSystemArraycopy;

    public static JavaStandardBeanProxyConstants getConstants(ProxyFactoryRegistry registry) {
        JavaStandardBeanProxyConstants constants = (JavaStandardBeanProxyConstants)registry.getConstants(REGISTRY_KEY);
        if (constants == null) {
            constants = new JavaStandardBeanProxyConstants(registry);
            registry.registerConstants(REGISTRY_KEY, constants);
        }
        return constants;
    }

    private JavaStandardBeanProxyConstants(ProxyFactoryRegistry registry) {
        IStandardBeanTypeProxyFactory typeFactory = registry.getBeanTypeProxyFactory();
        this.fCollectionType = typeFactory.getBeanTypeProxy("java.util.Collection");
        this.fListType = typeFactory.getBeanTypeProxy("java.util.List");
        this.fIteratorType = typeFactory.getBeanTypeProxy("java.util.Iterator");
        this.fListIteratorType = typeFactory.getBeanTypeProxy("java.util.ListIterator");
        this.fEnumerationType = typeFactory.getBeanTypeProxy("java.util.Enumeration");
        this.fSystemType = typeFactory.getBeanTypeProxy("java.lang.System");
        this.fStringType = typeFactory.getBeanTypeProxy("java.lang.String");
    }

    public IBeanTypeProxy getStringType() {
        return this.fStringType;
    }

    public IMethodProxy getCollectionAdd() {
        if (this.fCollectionAdd == null) {
            this.fCollectionAdd = this.fCollectionType.getMethodProxy("add", "java.lang.Object");
        }
        return this.fCollectionAdd;
    }

    public IMethodProxy getCollectionAddAll() {
        if (this.fCollectionAddAll == null) {
            this.fCollectionAddAll = this.fCollectionType.getMethodProxy("addAll", "java.util.Collection");
        }
        return this.fCollectionAddAll;
    }

    public IMethodProxy getCollectionClear() {
        if (this.fCollectionClear == null) {
            this.fCollectionClear = this.fCollectionType.getMethodProxy("clear");
        }
        return this.fCollectionClear;
    }

    public IMethodProxy getCollectionContains() {
        if (this.fCollectionContains == null) {
            this.fCollectionContains = this.fCollectionType.getMethodProxy("contains", "java.lang.Object");
        }
        return this.fCollectionContains;
    }

    public IMethodProxy getCollectionContainsAll() {
        if (this.fCollectionContainsAll == null) {
            this.fCollectionContainsAll = this.fCollectionType.getMethodProxy("containsAll", "java.util.Collection");
        }
        return this.fCollectionContainsAll;
    }

    public IMethodProxy getCollectionIsEmpty() {
        if (this.fCollectionIsEmpty == null) {
            this.fCollectionIsEmpty = this.fCollectionType.getMethodProxy("isEmpty");
        }
        return this.fCollectionIsEmpty;
    }

    public IMethodProxy getCollectionIterator() {
        if (this.fCollectionIterator == null) {
            this.fCollectionIterator = this.fCollectionType.getMethodProxy("iterator");
        }
        return this.fCollectionIterator;
    }

    public IMethodProxy getCollectionRemove() {
        if (this.fCollectionRemove == null) {
            this.fCollectionRemove = this.fCollectionType.getMethodProxy("remove", "java.lang.Object");
        }
        return this.fCollectionRemove;
    }

    public IMethodProxy getCollectionRemoveAll() {
        if (this.fCollectionRemoveAll == null) {
            this.fCollectionRemoveAll = this.fCollectionType.getMethodProxy("removeAll", "java.util.Collection");
        }
        return this.fCollectionRemoveAll;
    }

    public IMethodProxy getCollectionRetainAll() {
        if (this.fCollectionRetainAll == null) {
            this.fCollectionRetainAll = this.fCollectionType.getMethodProxy("retainAll", "java.util.Collection");
        }
        return this.fCollectionRetainAll;
    }

    public IMethodProxy getCollectionSize() {
        if (this.fCollectionSize == null) {
            this.fCollectionSize = this.fCollectionType.getMethodProxy("size");
        }
        return this.fCollectionSize;
    }

    public IMethodProxy getCollectionToArray() {
        if (this.fCollectionToArray == null) {
            this.fCollectionToArray = this.fCollectionType.getMethodProxy("toArray");
        }
        return this.fCollectionToArray;
    }

    public IMethodProxy getCollectionToArrayWithArray() {
        if (this.fCollectionToArrayWithArray == null) {
            this.fCollectionToArrayWithArray = this.fCollectionType.getMethodProxy("toArray", "[Ljava.lang.Object;");
        }
        return this.fCollectionToArrayWithArray;
    }

    public IMethodProxy getIteratorHasNext() {
        if (this.fIteratorHasNext == null) {
            this.fIteratorHasNext = this.fIteratorType.getMethodProxy("hasNext");
        }
        return this.fIteratorHasNext;
    }

    public IMethodProxy getIteratorNext() {
        if (this.fIteratorNext == null) {
            this.fIteratorNext = this.fIteratorType.getMethodProxy("next");
        }
        return this.fIteratorNext;
    }

    public IMethodProxy getIteratorRemove() {
        if (this.fIteratorRemove == null) {
            this.fIteratorRemove = this.fIteratorType.getMethodProxy("remove");
        }
        return this.fIteratorRemove;
    }

    public IMethodProxy getListAddWithInt() {
        if (this.fListAddWithInt == null) {
            this.fListAddWithInt = this.fListType.getMethodProxy("add", new String[]{"int", "java.lang.Object"});
        }
        return this.fListAddWithInt;
    }

    public IMethodProxy getListAddAllWithInt() {
        if (this.fListAddAllWithInt == null) {
            this.fListAddAllWithInt = this.fListType.getMethodProxy("addAll", new String[]{"int", "java.util.Collection"});
        }
        return this.fListAddAllWithInt;
    }

    public IMethodProxy getListGet() {
        if (this.fListGet == null) {
            this.fListGet = this.fListType.getMethodProxy("get", "int");
        }
        return this.fListGet;
    }

    public IMethodProxy getListIndexOf() {
        if (this.fListIndexOf == null) {
            this.fListIndexOf = this.fListType.getMethodProxy("indexOf", "java.lang.Object");
        }
        return this.fListIndexOf;
    }

    public IMethodProxy getListLastIndexOf() {
        if (this.fListLastIndexOf == null) {
            this.fListLastIndexOf = this.fListType.getMethodProxy("lastIndexOf", "java.lang.Object");
        }
        return this.fListLastIndexOf;
    }

    public IMethodProxy getListListIterator() {
        if (this.fListListIterator == null) {
            this.fListListIterator = this.fListType.getMethodProxy("listIterator");
        }
        return this.fListListIterator;
    }

    public IMethodProxy getListListIteratorWithInt() {
        if (this.fListListIteratorWithInt == null) {
            this.fListListIteratorWithInt = this.fListType.getMethodProxy("listIterator", "int");
        }
        return this.fListListIteratorWithInt;
    }

    public IMethodProxy getListRemoveInt() {
        if (this.fListRemoveInt == null) {
            this.fListRemoveInt = this.fListType.getMethodProxy("remove", "int");
        }
        return this.fListRemoveInt;
    }

    public IMethodProxy getListSet() {
        if (this.fListSet == null) {
            this.fListSet = this.fListType.getMethodProxy("set", new String[]{"int", "java.lang.Object"});
        }
        return this.fListSet;
    }

    public IMethodProxy getListSubList() {
        if (this.fListSubList == null) {
            this.fListSubList = this.fListType.getMethodProxy("subList", new String[]{"int", "int"});
        }
        return this.fListSubList;
    }

    public IMethodProxy getListIteratorAdd() {
        if (this.fListIteratorAdd == null) {
            this.fListIteratorAdd = this.fListIteratorType.getMethodProxy("add", "java.lang.Object");
        }
        return this.fListIteratorAdd;
    }

    public IMethodProxy getListIteratorHasPrevious() {
        if (this.fListIteratorHasPrevious == null) {
            this.fListIteratorHasPrevious = this.fListIteratorType.getMethodProxy("hasPrevious");
        }
        return this.fListIteratorHasPrevious;
    }

    public IMethodProxy getListIteratorNextIndex() {
        if (this.fListIteratorNextIndex == null) {
            this.fListIteratorNextIndex = this.fListIteratorType.getMethodProxy("nextIndex");
        }
        return this.fListIteratorNextIndex;
    }

    public IMethodProxy getListIteratorPrevious() {
        if (this.fListIteratorPrevious == null) {
            this.fListIteratorPrevious = this.fListIteratorType.getMethodProxy("previous");
        }
        return this.fListIteratorPrevious;
    }

    public IMethodProxy getListIteratorPreviousIndex() {
        if (this.fListIteratorPreviousIndex == null) {
            this.fListIteratorPreviousIndex = this.fListIteratorType.getMethodProxy("previousIndex");
        }
        return this.fListIteratorPreviousIndex;
    }

    public IMethodProxy getListIteratorSet() {
        if (this.fListIteratorSet == null) {
            this.fListIteratorSet = this.fListIteratorType.getMethodProxy("set", "java.lang.Object");
        }
        return this.fListIteratorSet;
    }

    public IMethodProxy getListIteratorRemove() {
        if (this.fListIteratorRemove == null) {
            this.fListIteratorRemove = this.fListIteratorType.getMethodProxy("remove");
        }
        return this.fListIteratorRemove;
    }

    protected IMethodProxy getSystemArraycopy() {
        if (this.fSystemArraycopy == null) {
            this.fSystemArraycopy = this.fSystemType.getMethodProxy("arraycopy", new String[]{"java.lang.Object", "int", "java.lang.Object", "int", "int"});
        }
        return this.fSystemArraycopy;
    }

    public IMethodProxy getEnumerationHasMoreElements() {
        if (this.fEnumerationHasMoreElements == null) {
            this.fEnumerationHasMoreElements = this.fEnumerationType.getMethodProxy("hasMoreElements");
        }
        return this.fEnumerationHasMoreElements;
    }

    public IMethodProxy getEnumerationNextElement() {
        if (this.fEnumerationNextElement == null) {
            this.fEnumerationNextElement = this.fEnumerationType.getMethodProxy("nextElement");
        }
        return this.fEnumerationNextElement;
    }

    public void arraycopy(IBeanProxy src, int srcPosition, IBeanProxy dest, int destPosition, int length) throws ThrowableProxy {
        IStandardBeanProxyFactory factory = src.getProxyFactoryRegistry().getBeanProxyFactory();
        IBeanProxy[] args = new IBeanProxy[]{src, factory.createBeanProxyWith(srcPosition), dest, factory.createBeanProxyWith(destPosition), factory.createBeanProxyWith(length)};
        this.getSystemArraycopy().invoke(null, args);
    }
}

