/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.JSPDomAdapter;

public class JSPUtil {
    public static List getActionListInJSPFile(String jspFileName) {
        ArrayList actions = new ArrayList();
        String physicalJspPath = jspFileName;
        if (physicalJspPath != null && physicalJspPath.length() > 0) {
            Path jspPath = new Path(physicalJspPath);
            IFile jspFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)jspPath);
            if (jspFile != null && jspFile.exists()) {
                JSPDomAdapter jspAdapter = null;
                try {
                    jspAdapter = new JSPDomAdapter();
                    if (jspAdapter.initialize(jspFile)) {
                        List linkActions;
                        String prefix = jspAdapter.getTagLibPrefix(JSPDomAdapter.JSF_HTML_TAGLIB);
                        List buttonActions = jspAdapter.getElementsByTagNameNS(prefix, "commandButton");
                        if (buttonActions != null) {
                            actions.addAll(buttonActions);
                        }
                        if ((linkActions = jspAdapter.getElementsByTagNameNS(prefix, "commandLink")) != null) {
                            actions.addAll(linkActions);
                        }
                    }
                }
                finally {
                    if (jspAdapter != null) {
                        jspAdapter.releaseModel();
                    }
                }
            }
        }
        return actions;
    }
}

