/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.document;

import java.io.IOException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;
import org.eclipse.wst.xml.core.tests.document.UnzippedProjectTester;

public class TransitionTests
extends UnzippedProjectTester {
    public void testSoftRevert() throws CoreException, IOException {
        String filePath = "testfiles/xml/EmptyFile.xml";
        IFile file = (IFile)fTestProject.findMember(filePath);
        TransitionTests.assertNotNull((String)("Test Case in error. Could not find file " + filePath), (Object)file);
        IPath locationPath = file.getLocation();
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        bufferManager.connect(locationPath, null);
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(locationPath);
        IDocument document = buffer.getDocument();
        TransitionTests.assertNotNull((Object)document);
        TransitionTests.assertTrue((String)"wrong class of document", (boolean)(document instanceof BasicStructuredDocument));
        TransitionTests.assertTrue((String)"wrong partitioner in document.", (boolean)(((IDocumentExtension3)document).getDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning") instanceof StructuredTextPartitionerForXML));
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)document);
        try {
            try {
                document.replace(0, 0, "__");
                document.replace(2, 0, "<a");
                document.replace(4, 0, ">");
                document.replace(5, 0, "  ");
            }
            catch (BadLocationException e) {
                TransitionTests.assertNull((Object)((Object)e));
            }
            document.set("");
        }
        finally {
            model.releaseFromEdit();
            bufferManager.disconnect(locationPath, null);
        }
    }
}

