/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests.testcase;

import java.io.UnsupportedEncodingException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.tests.T7A;
import org.eclipse.wst.validation.tests.testcase.TestEnvironment;

public class TestSuite7
extends TestCase {
    private TestEnvironment _env;
    private IProject _projectA;
    private IProject _projectB;

    public static Test suite() {
        return new TestSuite(TestSuite7.class);
    }

    public TestSuite7(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestEnvironment.enableOnlyThisValidator("org.eclipse.wst.validation.tests.T7A");
        this._env = new TestEnvironment();
        this._projectA = this._env.createProject("TestSuite7a");
        this._projectB = this._env.createProject("TestSuite7b");
        this.makeFiles(this._projectA);
        this.makeFiles(this._projectB);
    }

    private void makeFiles(IProject project) throws Exception {
        IPath first = this._env.addFolder(project.getFullPath(), "some-folder");
        this._env.addFile(first, "first.t7a", "# a dummy file");
        this._env.addFile(first, "second.t7a", "# a dummy file");
    }

    protected void tearDown() throws Exception {
        this._projectA.delete(true, null);
        this._projectB.delete(true, null);
        this._env.dispose();
        super.tearDown();
    }

    public void testClean() throws CoreException, UnsupportedEncodingException, InterruptedException {
        Tracing.log((String)"TestSuite7-01: testClean starting");
        NullProgressMonitor monitor = new NullProgressMonitor();
        this._env.turnOnAutoBuild();
        this._env.cleanBuild((IProgressMonitor)monitor);
        T7A.resetList();
        this._env.cleanBuild((IProgressMonitor)monitor);
        T7A.ValEntryPoint[] array = T7A.getArray();
        int start = 0;
        int finish = 0;
        T7A.ValEntryPoint[] valEntryPointArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T7A.ValEntryPoint vep = valEntryPointArray[n2];
            switch (vep.getType()) {
                case Starting: {
                    if (start == 0) {
                        TestSuite7.assertNull((String)"First starting entry must be null", (Object)vep.getResource());
                    }
                    ++start;
                    break;
                }
                case Finishing: {
                    ++finish;
                    break;
                }
                case Normal: {
                    TestSuite7.assertEquals((String)"All normal validation events must be two levels deep", (int)2, (int)(start - finish));
                }
            }
            ++n2;
        }
        TestSuite7.assertEquals((String)"Starting must equal finishing", (int)start, (int)finish);
        TestSuite7.assertNull((String)"Last entry must be null", (Object)array[array.length - 1].getResource());
        Tracing.log((String)"TestSuite7-02:testClean finished");
    }
}

