/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;

public final class CheckRequiresAndProvidesSorted
extends NodeTraversal.AbstractShallowCallback
implements HotSwapCompilerPass {
    public static final DiagnosticType REQUIRES_NOT_SORTED = DiagnosticType.warning("JSC_REQUIRES_NOT_SORTED", "goog.require() statements are not sorted.");
    public static final DiagnosticType PROVIDES_NOT_SORTED = DiagnosticType.warning("JSC_PROVIDES_NOT_SORTED", "goog.provide() statements are not sorted.");
    public static final DiagnosticType PROVIDES_AFTER_REQUIRES = DiagnosticType.warning("JSC_PROVIDES_AFTER_REQUIRES", "goog.provide() statements should be before goog.require() statements.");
    private List<Node> requires;
    private List<Node> provides;
    private boolean containsShorthandRequire = false;
    private final AbstractCompiler compiler;
    private final Function<Node, String> getNamespace = new Function<Node, String>(){

        public String apply(Node n) {
            Preconditions.checkState((boolean)n.isCall(), (Object)n);
            return n.getLastChild().getString();
        }
    };
    private final Ordering<Node> alphabetical = Ordering.natural().onResultOf(this.getNamespace);

    public CheckRequiresAndProvidesSorted(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.requires = new ArrayList<Node>();
        this.provides = new ArrayList<Node>();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 132: {
                if (!this.containsShorthandRequire) {
                    if (!this.alphabetical.isOrdered(this.requires)) {
                        t.report(this.requires.get(0), REQUIRES_NOT_SORTED, new String[0]);
                    }
                    if (!this.alphabetical.isOrdered(this.provides)) {
                        t.report(this.provides.get(0), PROVIDES_NOT_SORTED, new String[0]);
                    }
                }
                this.requires.clear();
                this.provides.clear();
                this.containsShorthandRequire = false;
                break;
            }
            case 37: {
                Node callee = n.getFirstChild();
                if (!(callee.matchesQualifiedName("goog.require") || callee.matchesQualifiedName("goog.provide") || callee.matchesQualifiedName("goog.module"))) {
                    return;
                }
                if (parent.isExprResult() && parent.getParent().isScript()) {
                    String namespace = n.getLastChild().getString();
                    if (namespace == null) {
                        return;
                    }
                    if (callee.matchesQualifiedName("goog.require")) {
                        this.requires.add(n);
                        break;
                    }
                    if (!this.requires.isEmpty()) {
                        t.report(n, PROVIDES_AFTER_REQUIRES, new String[0]);
                    }
                    if (!callee.matchesQualifiedName("goog.provide")) break;
                    this.provides.add(n);
                    break;
                }
                if (!NodeUtil.isNameDeclaration(parent.getParent()) || !callee.matchesQualifiedName("goog.require")) break;
                this.containsShorthandRequire = true;
            }
        }
    }
}

