/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.navigator;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.internal.jface.ItemTreeStateProviderManager;
import org.eclipse.jpt.common.ui.jface.ExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.TreeStateProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public abstract class NavigatorContentProvider
implements ICommonContentProvider {
    protected ResourceManager resourceManager;
    protected TreeStateProvider delegate;

    protected NavigatorContentProvider() {
    }

    public void init(ICommonContentExtensionSite config) {
        this.resourceManager = this.buildResourceManager();
        this.delegate = this.buildDelegate();
    }

    protected abstract ResourceManager buildResourceManager();

    protected TreeStateProvider buildDelegate() {
        return new ItemTreeStateProviderManager(this.buildItemContentProviderFactory(), this.buildItemLabelProviderFactory(), this.resourceManager);
    }

    protected abstract ItemTreeContentProvider.Factory buildItemContentProviderFactory();

    protected abstract ItemExtendedLabelProvider.Factory buildItemLabelProviderFactory();

    public void inputChanged(Viewer commonViewer, Object oldInput, Object newInput) {
        this.delegate.inputChanged(commonViewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.delegate.getElements(inputElement);
    }

    public Object getParent(Object element) {
        return this.delegate.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.delegate.hasChildren(element);
    }

    public Object[] getChildren(Object element) {
        return this.delegate.getChildren(element);
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public void dispose() {
        this.delegate.dispose();
        this.resourceManager.dispose();
    }

    ExtendedLabelProvider getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }
}

