/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLTools {
    private static DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY;
    private static DocumentBuilder DOCUMENT_BUILDER;
    private static TransformerFactory TRANSFORMER_FACTORY;
    private static Transformer TRANSFORMER;

    public static synchronized Document parse(InputSource inputSource) {
        try {
            return XMLTools.getDocumentBuilder().parse(inputSource);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Document parse(Reader reader) {
        Document document = null;
        try {
            document = XMLTools.parse(new InputSource(reader));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return document;
    }

    public static Document parse(InputStream inputStream) {
        try {
            return XMLTools.parse(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Document parse(File file) {
        BufferedInputStream inputStream;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file), 8192);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        Document document = XMLTools.parse(inputStream);
        try {
            ((InputStream)inputStream).close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return document;
    }

    private static synchronized DocumentBuilder getDocumentBuilder() {
        if (DOCUMENT_BUILDER == null) {
            try {
                DOCUMENT_BUILDER = XMLTools.getDocumentBuilderFactory().newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException(ex);
            }
        }
        return DOCUMENT_BUILDER;
    }

    private static synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        if (DOCUMENT_BUILDER_FACTORY == null) {
            DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
        }
        return DOCUMENT_BUILDER_FACTORY;
    }

    public static Node getChild(Node parent, String childName) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && child.getNodeName().equals(childName)) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static Iterable<Node> getChildren(Node node) {
        NodeList children = node.getChildNodes();
        int len = children.getLength();
        ArrayList<Node> result = new ArrayList<Node>(len);
        int i = 0;
        while (i < len) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                result.add(child);
            }
            ++i;
        }
        return result;
    }

    public static Iterable<Node> getChildren(Node node, String childName) {
        NodeList children = node.getChildNodes();
        int len = children.getLength();
        ArrayList<Node> result = new ArrayList<Node>(len);
        int i = 0;
        while (i < len) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(childName)) {
                result.add(child);
            }
            ++i;
        }
        return result;
    }

    public static String getTextContent(Node node) {
        Node child;
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            return "";
        }
        if (children.getLength() == 1 && (child = children.item(0)).getNodeType() == 3) {
            return node.getFirstChild().getNodeValue();
        }
        throw new IllegalArgumentException(node.getNodeName());
    }

    public static String getChildTextContent(Node parent, String childName) {
        return XMLTools.getTextContent(XMLTools.getChild(parent, childName));
    }

    public static String getChildTextContent(Node parent, String childName, String defaultValue) {
        Node child = XMLTools.getChild(parent, childName);
        return child == null ? defaultValue : XMLTools.getTextContent(child);
    }

    public static int getChildIntContent(Node parent, String childName) {
        return XMLTools.convertToInt(XMLTools.getTextContent(XMLTools.getChild(parent, childName)));
    }

    public static int childIntContent(Node parent, String childName, int defaultValue) {
        Node child = XMLTools.getChild(parent, childName);
        return child == null ? defaultValue : XMLTools.convertToInt(XMLTools.getTextContent(child));
    }

    private static int convertToInt(String string) {
        return Integer.parseInt(string);
    }

    public static boolean getChildBooleanContent(Node parent, String childName) {
        return XMLTools.convertToBoolean(XMLTools.getTextContent(XMLTools.getChild(parent, childName)));
    }

    public static boolean getChildBooleanContent(Node parent, String childName, boolean defaultValue) {
        Node child = XMLTools.getChild(parent, childName);
        return child == null ? defaultValue : XMLTools.convertToBoolean(XMLTools.getTextContent(child));
    }

    private static boolean convertToBoolean(String string) {
        String s = string.toLowerCase();
        if (s.equals("t") || s.equals("true") || s.equals("1")) {
            return true;
        }
        if (s.equals("f") || s.equals("false") || s.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException(string);
    }

    public static Document newDocument() {
        return XMLTools.getDocumentBuilder().newDocument();
    }

    public static void addSimpleTextNode(Node parent, String childName, String text) {
        Document document = parent.getOwnerDocument();
        Element child = document.createElement(childName);
        Text childTextNode = document.createTextNode(text);
        child.appendChild(childTextNode);
        parent.appendChild(child);
    }

    public static void addSimpleTextNode(Node parent, String childName, String text, String defaultValue) {
        if (!text.equals(defaultValue)) {
            XMLTools.addSimpleTextNode(parent, childName, text);
        }
    }

    public static void addSimpleTextNode(Node parent, String childName, int text) {
        XMLTools.addSimpleTextNode(parent, childName, String.valueOf(text));
    }

    public static void addSimpleTextNode(Node parent, String childName, int text, int defaultValue) {
        if (text != defaultValue) {
            XMLTools.addSimpleTextNode(parent, childName, text);
        }
    }

    public static void addSimpleTextNode(Node parent, String childName, boolean text) {
        XMLTools.addSimpleTextNode(parent, childName, String.valueOf(text));
    }

    public static void addSimpleTextNode(Node parent, String childName, boolean text, boolean defaultValue) {
        if (text != defaultValue) {
            XMLTools.addSimpleTextNode(parent, childName, text);
        }
    }

    public static void addSimpleTextNodes(Node parent, String childrenName, String childName, String[] childrenTexts) {
        Element childrenNode = parent.getOwnerDocument().createElement(childrenName);
        parent.appendChild(childrenNode);
        int len = childrenTexts.length;
        int i = 0;
        while (i < len) {
            XMLTools.addSimpleTextNode((Node)childrenNode, childName, childrenTexts[i]);
            ++i;
        }
    }

    public static synchronized void print(Source source, Result result) {
        try {
            XMLTools.getTransformer().transform(source, result);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void print(Document document, OutputStream outputStream) {
        XMLTools.print(new DOMSource(document), new StreamResult(outputStream));
    }

    public static void print(Document document, File file) {
        BufferedOutputStream outputStream;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file), 8192);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        XMLTools.print(document, outputStream);
        try {
            ((OutputStream)outputStream).close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static synchronized Transformer getTransformer() {
        if (TRANSFORMER == null) {
            try {
                TRANSFORMER = XMLTools.getTransformerFactory().newTransformer();
            }
            catch (TransformerConfigurationException ex) {
                throw new RuntimeException(ex);
            }
            try {
                TRANSFORMER.setOutputProperty("indent", "yes");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return TRANSFORMER;
    }

    private static synchronized TransformerFactory getTransformerFactory() {
        if (TRANSFORMER_FACTORY == null) {
            TRANSFORMER_FACTORY = TransformerFactory.newInstance();
        }
        return TRANSFORMER_FACTORY;
    }

    private XMLTools() {
        throw new UnsupportedOperationException();
    }
}

