/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.search;

import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.tests.search.AbstractSearchTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestMethodSearch
extends AbstractSearchTest {
    @Test
    public void testDeclarationSearch01() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), this.getName(), new String[]{"X.js"}, new String[]{"var searchVar = {\n\t" + this.getName() + ": function() {},\n" + "\t" + this.getName() + "XYZ: function() {},\n" + "};\n"}, 1, 0, 0);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testDeclarationSearch02() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "searchVar." + this.getName(), new String[]{"X.js"}, new String[]{"var searchVar = function() {\n\tthis." + this.getName() + " = function() {};\n" + "\tthis." + this.getName() + "XYZ = function() {};\n" + "};"}, 1, 0, 0);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    @Ignore(value="prototype is not handled well by ASTParser")
    public void testDeclarationSearch03() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "SearchConstructor." + this.getName(), new String[]{"X.js"}, new String[]{"SearchConstructor.prototype." + this.getName() + " = function() {};\n" + "SearchConstructor2.prototype." + this.getName() + " = function() {};\n"}, 1, 0, 0);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testDeclarationSearch04() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "*." + this.getName(), new String[]{"X.js"}, new String[]{"var searchVar = function() {\n\tthis." + this.getName() + " = function() {};\n" + "\tthis." + this.getName() + "XYZ = function() {};\n" + "};"}, 1, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testDeclarationSearch05() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "testdec*", new String[]{"X.js"}, new String[]{"var searchVar = {\n\t" + this.getName() + ": function() {},\n" + "\t" + this.getName() + "XYZ: function() {},\n" + "};\n"}, 1, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    @Ignore(value="Prototype is not handled well by ASTParser")
    public void testDeclarationSearch06() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "SearchConstructor.*", new String[]{"X.js"}, new String[]{"SearchConstructor.prototype." + this.getName() + " = function() {};\n" + "SearchConstructor.prototype." + this.getName() + "XYZ = function() {};\n"}, 1, 0, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    public void testReferencesSearch01() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), String.valueOf(this.getName()) + "xyz", new String[]{"X.js", "Y.js"}, new String[]{"var searchVar = {\n\t" + this.getName() + ": function() {},\n" + "\t" + this.getName() + "XYZ: function() {},\n" + "};\n", "searchVar." + this.getName() + "();\n" + "searchVar." + this.getName() + "XYZ();\n"}, 1, 2, 0);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)1L, (long)results.length);
    }

    @Test
    public void testReferencesSearch02() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "testref*", new String[]{"X.js", "Y.js"}, new String[]{"var searchVar = function() {\n\tthis." + this.getName() + " = function() {};\n" + "\tthis." + this.getName() + "XYZ = function() {};\n" + "};", "searchVar." + this.getName() + "();\n" + "searchVar." + this.getName() + "XYZ();\n"}, 1, 2, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    public void testReferencesSearch03() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "TESTREF*", new String[]{"X.js", "Y.js"}, new String[]{"var searchVar = function() {\n\tthis." + this.getName() + " = function() {};\n" + "\tthis." + this.getName() + "XYZ = function() {};\n" + "};", "searchVar." + this.getName() + "();\n" + "searchVar." + this.getName() + "XYZ();\n"}, 1, 2, 10);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)0L, (long)results.length);
    }

    @Test
    public void testOccurrencesSearch01() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"var searchVar = {\n\t" + this.getName() + ": function() {}\n" + "};\n", "searchVar." + this.getName() + "();"}, 1, 3, 0);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)2L, (long)results.length);
    }

    @Test
    public void testOccurrencesSearch02() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "testocc*", new String[]{"X.js", "Y.js"}, new String[]{"var searchVar = function() {\n\tthis." + this.getName() + " = function() {};\n" + "\tthis." + this.getName() + "XYZ = function() {};\n" + "};", "searchVar." + this.getName() + "();\n" + "searchVar." + this.getName() + "XYZ();\n"}, 1, 3, 2);
        Assert.assertEquals((String)"wrong number of files containing references found", (long)4L, (long)results.length);
    }
}

