/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.io;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.io.IndentingPrintWriter;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class IndentingPrintWriterTests
extends TestCase {
    StringWriter sw1;
    StringWriter sw2;
    IndentingPrintWriter ipw1;
    IndentingPrintWriter ipw2;
    static final String CR = System.getProperty("line.separator");

    public IndentingPrintWriterTests(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.sw1 = new StringWriter();
        this.ipw1 = new IndentingPrintWriter((Writer)this.sw1);
        this.sw2 = new StringWriter();
        this.ipw2 = new IndentingPrintWriter((Writer)this.sw2, "    ");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIndent() {
        IndentingPrintWriterTests.assertEquals((String)"wrong indent level", (int)0, (int)this.ipw1.getIndentLevel());
        this.ipw1.indent();
        IndentingPrintWriterTests.assertEquals((String)"wrong indent level", (int)1, (int)this.ipw1.getIndentLevel());
    }

    public void testUndent() {
        IndentingPrintWriterTests.assertEquals((String)"wrong indent level", (int)0, (int)this.ipw1.getIndentLevel());
        this.ipw1.indent();
        IndentingPrintWriterTests.assertEquals((String)"wrong indent level", (int)1, (int)this.ipw1.getIndentLevel());
        this.ipw1.undent();
        IndentingPrintWriterTests.assertEquals((String)"wrong indent level", (int)0, (int)this.ipw1.getIndentLevel());
    }

    public void testIncrementIndentLevel() {
        IndentingPrintWriterTests.assertEquals((String)"wrong indent level", (int)0, (int)this.ipw1.getIndentLevel());
        this.ipw1.incrementIndentLevel();
        IndentingPrintWriterTests.assertEquals((String)"wrong indent level", (int)1, (int)this.ipw1.getIndentLevel());
    }

    public void testDecrementIndentLevel() {
        IndentingPrintWriterTests.assertEquals((String)"wrong indent level", (int)0, (int)this.ipw1.getIndentLevel());
        this.ipw1.incrementIndentLevel();
        IndentingPrintWriterTests.assertEquals((String)"wrong indent level", (int)1, (int)this.ipw1.getIndentLevel());
        this.ipw1.decrementIndentLevel();
        IndentingPrintWriterTests.assertEquals((String)"wrong indent level", (int)0, (int)this.ipw1.getIndentLevel());
    }

    public void testPrintTab() {
        String expected = "foo0" + CR + "\tfoo1" + CR + "\tfoo1" + CR + "\t\tfoo2" + CR + "\tfoo1" + CR + "\tfoo1" + CR + "foo0" + CR;
        this.ipw1.println("foo0");
        this.ipw1.indent();
        this.ipw1.println("foo1");
        this.ipw1.println("foo1");
        this.ipw1.indent();
        this.ipw1.println("foo2");
        this.ipw1.undent();
        this.ipw1.println("foo1");
        this.ipw1.println("foo1");
        this.ipw1.undent();
        this.ipw1.println("foo0");
        IndentingPrintWriterTests.assertEquals((String)"bogus output", (String)expected, (String)this.sw1.toString());
    }

    public void testPrintSpaces() {
        String expected = "foo0" + CR + "    foo1" + CR + "    foo1" + CR + "        foo2" + CR + "    foo1" + CR + "    foo1" + CR + "foo0" + CR;
        this.ipw2.println("foo0");
        this.ipw2.indent();
        this.ipw2.println("foo1");
        this.ipw2.println("foo1");
        this.ipw2.indent();
        this.ipw2.println("foo2");
        this.ipw2.undent();
        this.ipw2.println("foo1");
        this.ipw2.println("foo1");
        this.ipw2.undent();
        this.ipw2.println("foo0");
        IndentingPrintWriterTests.assertEquals((String)"bogus output", (String)expected, (String)this.sw2.toString());
    }
}

