/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.IdTypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.jpa.core.context.java.JavaIdTypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.GenericJavaIdClassReference;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractJavaIdTypeMapping<A extends Annotation>
extends AbstractJavaTypeMapping<A>
implements JavaIdTypeMapping {
    protected IdTypeMapping superTypeMapping;
    protected final JavaIdClassReference idClassReference = this.buildIdClassReference();

    protected AbstractJavaIdTypeMapping(JavaPersistentType parent, A mappingAnnotation) {
        super(parent, mappingAnnotation);
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.idClassReference.synchronizeWithResourceModel(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setSuperTypeMapping_(this.findSuperTypeMapping());
        this.idClassReference.update(monitor);
    }

    @Override
    public JavaIdClassReference getIdClassReference() {
        return this.idClassReference;
    }

    protected JavaIdClassReference buildIdClassReference() {
        return new GenericJavaIdClassReference(this);
    }

    @Override
    public String getPrimaryKeyClassName() {
        String idClassName = this.getIdClassReference().getFullyQualifiedIdClassName();
        if (StringTools.isNotBlank((String)idClassName)) {
            return idClassName;
        }
        AttributeMapping idMapping = this.getIdAttributeMapping();
        if (idMapping != null) {
            return idMapping.getPersistentAttribute().getTypeName();
        }
        return null;
    }

    @Override
    public IdTypeMapping getSuperTypeMapping() {
        return this.superTypeMapping;
    }

    protected void setSuperTypeMapping_(IdTypeMapping typeMapping) {
        IdTypeMapping old = this.superTypeMapping;
        this.superTypeMapping = typeMapping;
        this.firePropertyChanged("superTypeMapping", old, typeMapping);
    }

    protected IdTypeMapping findSuperTypeMapping() {
        return this.findSuperTypeMapping(this.getJavaResourceType());
    }

    protected IdTypeMapping findSuperTypeMapping(JavaResourceType resourceType) {
        String thisTypeName = this.getJavaResourceType().getTypeBinding().getQualifiedName();
        String superTypeName = resourceType.getSuperclassQualifiedName();
        if (superTypeName == null || ObjectTools.equals((Object)thisTypeName, (Object)superTypeName)) {
            return null;
        }
        IdTypeMapping typeMapping = this.findTypeMapping(superTypeName);
        if (typeMapping != null) {
            return typeMapping;
        }
        JavaResourceType superResourceType = this.findResourceType(superTypeName);
        return superResourceType == null ? null : this.findSuperTypeMapping(superResourceType);
    }

    protected JavaResourceType findResourceType(String typeName) {
        return (JavaResourceType)this.getJpaProject().getJavaResourceType(typeName, JavaResourceAnnotatedElement.AstNodeType.TYPE);
    }

    protected IdTypeMapping findTypeMapping(String typeName) {
        return this.getPersistenceUnit().getIdTypeMapping(typeName);
    }

    @Override
    public Iterable<IdTypeMapping> getInheritanceHierarchy() {
        return this.buildInheritanceHierarchy(this);
    }

    @Override
    public Iterable<IdTypeMapping> getAncestors() {
        return this.superTypeMapping == null ? IterableTools.emptyIterable() : this.buildInheritanceHierarchy(this.superTypeMapping);
    }

    protected Iterable<IdTypeMapping> buildInheritanceHierarchy(IdTypeMapping start) {
        return ObjectTools.chain((Object)start, (Transformer)new IdTypeMapping.SuperTypeMappingTransformer(this));
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validatePrimaryKey(messages, reporter);
        this.idClassReference.validate(messages, reporter);
    }

    protected void validatePrimaryKey(List<IMessage> messages, IReporter reporter) {
        this.buildPrimaryKeyValidator().validate(messages, reporter);
    }

    protected abstract JpaValidator buildPrimaryKeyValidator();
}

