/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.factory;

import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class SafeFactoryWrapper<T>
implements Factory<T> {
    private final Factory<? extends T> factory;
    private final ExceptionHandler exceptionHandler;
    private final T exceptionValue;

    public SafeFactoryWrapper(Factory<? extends T> factory, ExceptionHandler exceptionHandler, T exceptionOutput) {
        if (factory == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.factory = factory;
        this.exceptionHandler = exceptionHandler;
        this.exceptionValue = exceptionOutput;
    }

    @Override
    public T create() {
        try {
            return this.factory.create();
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
            return this.exceptionValue;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.factory);
    }
}

