/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.elementedit.jsfhtml;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.actions.single.SelectEditPartAction;
import org.eclipse.jst.pagedesigner.editpolicies.ElementResizableEditPolicy;
import org.eclipse.jst.pagedesigner.jsf.ui.JSFUIPlugin;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.DeleteHeaderFooterAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.InsertHeaderFooterAction;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.DataTableDeleteHeaderCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.PanelGridDeleteColumnCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.PanelGridDeleteRowCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.PanelGridInsertColumnCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.PanelGridInsertFooterCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.PanelGridInsertHeaderCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.PanelGridInsertRowCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.elementedit.jsfhtml.DefaultJSFHTMLElementEdit;
import org.eclipse.jst.pagedesigner.jsf.ui.elementedit.request.DeleteHeaderFooterRequest;
import org.eclipse.jst.pagedesigner.jsf.ui.elementedit.request.InsertHeaderFooterRequest;
import org.eclipse.jst.pagedesigner.jsf.ui.elementedit.util.PanelGridUtil;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.tableedit.DeleteRowColumnAction;
import org.eclipse.jst.pagedesigner.tableedit.InsertRowColumnAction;
import org.eclipse.jst.pagedesigner.tableedit.TableInsertRequest;
import org.eclipse.jst.pagedesigner.tableedit.TableResizeRequest;
import org.eclipse.jst.pagedesigner.tableedit.TableRowColumnDeleteRequest;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PanelGridElementEdit
extends DefaultJSFHTMLElementEdit {
    private static final Action EMPTY_ACTION = new Action(){};
    private static final int FAKE_INDEX = -10;

    @Override
    public void fillContextMenu(IMenuManager contextMenu, Element ele) {
        super.fillContextMenu(contextMenu, ele);
        MenuManager tableMenu = new MenuManager(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid"));
        tableMenu.add((IAction)EMPTY_ACTION);
        ElementEditPart gridEditPart = (ElementEditPart)((IDOMElement)ele).getAdapterFor(EditPart.class);
        tableMenu.addMenuListener(new IMenuListener((IMenuManager)tableMenu, gridEditPart){
            private final /* synthetic */ IMenuManager val$tableMenu;
            private final /* synthetic */ ElementEditPart val$gridEditPart;
            {
                this.val$tableMenu = iMenuManager;
                this.val$gridEditPart = elementEditPart;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$tableMenu.removeAll();
                PanelGridElementEdit.this.fillPanelGridMenu(this.val$gridEditPart, -10, -10, this.val$tableMenu);
            }
        });
        contextMenu.appendToGroup("org.eclipse.jst.pagedesigner.container", (IContributionItem)tableMenu);
    }

    public boolean fillContainerContextMenu(IMenuManager contextMenu, ElementEditPart elePart, NodeEditPart nodePart, ISelection innerSelection) {
        Element table = (Element)elePart.getModel();
        Node node = (Node)nodePart.getModel();
        Element childEle = null;
        if (node instanceof Element) {
            childEle = (Element)node;
        } else {
            boolean hasElementParent = false;
            Node nodeBackup = node;
            while (!"panelGrid".equalsIgnoreCase(nodeBackup.getParentNode().getLocalName())) {
                if (!((nodeBackup = nodeBackup.getParentNode()) instanceof Element)) continue;
                hasElementParent = true;
                break;
            }
            if (!hasElementParent) {
                return false;
            }
            childEle = (Element)nodeBackup;
        }
        PanelGridUtil util = new PanelGridUtil(table);
        int cellRow = util.convertRowIndexFromDomToView(util.getDomRowIndex(childEle));
        int cellColumn = util.getDomColumnIndex(childEle);
        MenuManager tableMenu = new MenuManager(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid"));
        tableMenu.add((IAction)EMPTY_ACTION);
        tableMenu.addMenuListener(new IMenuListener((IMenuManager)tableMenu, elePart, cellRow, cellColumn){
            private final /* synthetic */ IMenuManager val$tableMenu;
            private final /* synthetic */ ElementEditPart val$elePart;
            private final /* synthetic */ int val$cellRow;
            private final /* synthetic */ int val$cellColumn;
            {
                this.val$tableMenu = iMenuManager;
                this.val$elePart = elementEditPart;
                this.val$cellRow = n;
                this.val$cellColumn = n2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$tableMenu.removeAll();
                PanelGridElementEdit.this.fillPanelGridMenu(this.val$elePart, this.val$cellRow, this.val$cellColumn, this.val$tableMenu);
            }
        });
        contextMenu.appendToGroup("org.eclipse.jst.pagedesigner.container", (IContributionItem)tableMenu);
        return true;
    }

    private void fillPanelGridMenu(ElementEditPart elePart, int cellRow, int cellColumn, IMenuManager tableMenu) {
        SelectEditPartAction action = SelectEditPartAction.create((String)JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid.SelectTable"), (EditPart)elePart);
        tableMenu.add((IAction)action);
        tableMenu.add((IContributionItem)new Separator());
        InsertRowColumnAction insertRowBeforeAction = new InsertRowColumnAction(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid.InsertRowBefore"), (EditPart)elePart, cellRow, true, true);
        tableMenu.add((IAction)insertRowBeforeAction);
        InsertRowColumnAction insertRowAfterAction = new InsertRowColumnAction(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid.InsertRowAfter"), (EditPart)elePart, cellRow, true, false);
        tableMenu.add((IAction)insertRowAfterAction);
        tableMenu.add((IContributionItem)new Separator());
        InsertRowColumnAction insertColumnBeforeAction = new InsertRowColumnAction(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid.InsertColumnBefore"), (EditPart)elePart, cellColumn, false, true);
        tableMenu.add((IAction)insertColumnBeforeAction);
        InsertRowColumnAction insertColumnAfterAction = new InsertRowColumnAction(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid.InsertColumnAfter"), (EditPart)elePart, cellColumn, false, false);
        tableMenu.add((IAction)insertColumnAfterAction);
        tableMenu.add((IContributionItem)new Separator());
        DeleteRowColumnAction deleteRowAction = new DeleteRowColumnAction(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid.DeleteRow"), (EditPart)elePart, cellRow, true);
        tableMenu.add((IAction)deleteRowAction);
        DeleteRowColumnAction deleteColumnAction = new DeleteRowColumnAction(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid.DeleteColumn"), (EditPart)elePart, cellColumn, false);
        tableMenu.add((IAction)deleteColumnAction);
        tableMenu.add((IContributionItem)new Separator());
        InsertHeaderFooterAction headerAction = new InsertHeaderFooterAction(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid.InsertHeader"), (EditPart)elePart, true);
        tableMenu.add((IAction)headerAction);
        InsertHeaderFooterAction footerAction = new InsertHeaderFooterAction(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid.InsertFooter"), (EditPart)elePart, false);
        tableMenu.add((IAction)footerAction);
        DeleteHeaderFooterAction delHeaderAction = new DeleteHeaderFooterAction(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGird.DeleteHeader"), (EditPart)elePart, true);
        tableMenu.add((IAction)delHeaderAction);
        DeleteHeaderFooterAction delFooterAction = new DeleteHeaderFooterAction(JSFUIPlugin.getResourceString("ElementEdit.Submenu.PanelGrid.DeleteFooter"), (EditPart)elePart, false);
        tableMenu.add((IAction)delFooterAction);
    }

    public void createEditPolicies(ElementEditPart part) {
        part.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new PanelGridResizePolicy(part));
    }

    static class PanelGridResizePolicy
    extends ElementResizableEditPolicy {
        ElementEditPart _part;

        public PanelGridResizePolicy(ElementEditPart part) {
            this._part = part;
        }

        public Cursor getSelectionToolCursor(Point mouseLocation) {
            GraphicalEditPart part = (GraphicalEditPart)this.getHost();
            IFigure panelFigure = part.getFigure();
            Point relativeLocation = mouseLocation.getCopy();
            panelFigure.translateToRelative((Translatable)relativeLocation);
            int xoffsetAbs = Math.abs(panelFigure.getBounds().x - relativeLocation.x);
            if (xoffsetAbs <= 2) {
                return SharedCursors.SIZEE;
            }
            int yoffsetAbs = Math.abs(panelFigure.getBounds().y - relativeLocation.y);
            if (yoffsetAbs <= 2) {
                return SharedCursors.SIZEW;
            }
            return null;
        }

        public Command getCommand(Request request) {
            IHTMLGraphicalViewer viewer = (IHTMLGraphicalViewer)this._part.getViewer();
            Element panelGrid = (Element)this._part.getIDOMNode();
            if (request instanceof TableResizeRequest) {
                return super.getCommand(request);
            }
            if (request instanceof TableInsertRequest) {
                TableInsertRequest tableInsertRequest = (TableInsertRequest)request;
                if (tableInsertRequest.isRow()) {
                    int index = tableInsertRequest.getIndex() + (tableInsertRequest.isBefore() ? 0 : 1);
                    return new PanelGridInsertRowCommand(viewer, panelGrid, index);
                }
                int index = tableInsertRequest.getIndex() + (tableInsertRequest.isBefore() ? 0 : 1);
                return new PanelGridInsertColumnCommand(viewer, panelGrid, index);
            }
            if (request instanceof InsertHeaderFooterRequest) {
                InsertHeaderFooterRequest req = (InsertHeaderFooterRequest)request;
                boolean isHeader = req.isHeader();
                if (isHeader) {
                    return new PanelGridInsertHeaderCommand(viewer, panelGrid);
                }
                return new PanelGridInsertFooterCommand(viewer, panelGrid);
            }
            if (request instanceof DeleteHeaderFooterRequest) {
                DeleteHeaderFooterRequest req = (DeleteHeaderFooterRequest)request;
                boolean isHeader = req.isHeader();
                return new DataTableDeleteHeaderCommand(viewer, panelGrid, isHeader);
            }
            if (request instanceof TableRowColumnDeleteRequest) {
                TableRowColumnDeleteRequest deleteReq = (TableRowColumnDeleteRequest)request;
                if (deleteReq.isRow()) {
                    return new PanelGridDeleteRowCommand(viewer, panelGrid, deleteReq.getIndex());
                }
                return new PanelGridDeleteColumnCommand(viewer, panelGrid, deleteReq.getIndex());
            }
            return super.getCommand(request);
        }
    }
}

