/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.wtp.releng.tests.RuleData;

public class ComparatorRules {
    private String filterPropertyFileLocation = null;
    private static final String COMPARATOR_FILTER_RULES = "comparatorFilterRules";
    String defaultfilterPropertyFileLocation = "/home/davidw/builds/workspaces/wtpHead/releng/maps/comparatorfilter.properties";

    public static void main(String[] args) {
        try {
            ComparatorRules comparatorRules = new ComparatorRules();
            ArrayList<RuleData> testlist = comparatorRules.getDataRules();
            for (RuleData ruleData : testlist) {
                System.out.println(ruleData);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Properties getRuleProperties() throws IOException {
        Properties filterProperties = null;
        String fileLocationAndName = this.getFilterPropertyFileLocation();
        File file = new File(fileLocationAndName);
        FileInputStream inStream = new FileInputStream(file);
        filterProperties = new Properties();
        filterProperties.load(inStream);
        ((InputStream)inStream).close();
        return filterProperties;
    }

    public ArrayList<RuleData> getDataRules() throws IOException {
        ArrayList<RuleData> ruleList = new ArrayList<RuleData>();
        Properties filterProperties = this.getRuleProperties();
        Enumeration<?> filterKeys = filterProperties.propertyNames();
        while (filterKeys.hasMoreElements()) {
            String key = (String)filterKeys.nextElement();
            String rulename = this.getRulename(key);
            String summarykey = "comparator." + rulename + ".summary";
            String summary = (String)filterProperties.remove(summarykey);
            String comparisonkey = "comparator." + rulename + ".comparison";
            String comparison = (String)filterProperties.remove(comparisonkey);
            String reasonkey = "comparator." + rulename + ".reason";
            String reason = (String)filterProperties.remove(reasonkey);
            if (summary == null && comparison == null && reason == null) continue;
            ruleList.add(new RuleData(rulename, summary, comparison, reason));
        }
        return ruleList;
    }

    private String getRulename(String key) {
        StringTokenizer namefinder = new StringTokenizer(key, ".");
        if (namefinder.countTokens() != 3) {
            throw new IllegalStateException("Invalid property found in comparator rule property file: key without 3 parts");
        }
        String namespace = namefinder.nextToken();
        if (!namespace.equals("comparator")) {
            throw new IllegalStateException("Invalid property found in comparator rule property file: not of 'comparator' namespace");
        }
        String rulename = namefinder.nextToken();
        String ruletype = namefinder.nextToken();
        if (!(ruletype.equals("summary") || ruletype.equals("comparison") || ruletype.equals("reason"))) {
            throw new IllegalStateException("Invalid property found in comparator rule property file: unrecognized rule type");
        }
        return rulename;
    }

    public String getFilterPropertyFileLocation() {
        if (this.filterPropertyFileLocation == null) {
            this.filterPropertyFileLocation = System.getProperty(COMPARATOR_FILTER_RULES);
            if (this.filterPropertyFileLocation == null || this.filterPropertyFileLocation.length() <= 0) {
                this.filterPropertyFileLocation = this.defaultfilterPropertyFileLocation;
            }
        }
        return this.filterPropertyFileLocation;
    }

    public void setFilterPropertyFileLocation(String filterPropertyFileLocation) {
        this.filterPropertyFileLocation = filterPropertyFileLocation;
    }
}

