/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.text;

import com.ibm.icu.text.DecimalFormat;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextPartitioner;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.tests.text.NullStream;

public class TestStructuredPartitionerXML
extends TestCase {
    private boolean DEBUG_PRINT_RESULT = false;
    protected ITypedRegion[] partitions = null;
    private boolean useFormatter = true;
    protected DecimalFormat formatter;

    public TestStructuredPartitionerXML(String name) {
        super(name);
        if (this.DEBUG_PRINT_RESULT && this.useFormatter) {
            this.formatter = new DecimalFormat();
        }
    }

    private IStructuredModel getModelForEdit(String filename) {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
            if (inStream == null) {
                inStream = new NullStream();
            }
            model = modelManager.getModelForEdit(filename, inStream, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return model;
    }

    public void testDisconnectConnect() {
        block9: {
            IStructuredModel model = null;
            try {
                model = this.getModelForEdit("testfiles/xml/example01.xml");
                if (model != null) {
                    IStructuredDocument sDoc = model.getStructuredDocument();
                    TestStructuredPartitionerXML.assertTrue((String)"sDoc implementation not instance of IDocumentExtension3", (boolean)(sDoc instanceof IDocumentExtension3));
                    IDocumentPartitioner partitioner = ((IDocumentExtension3)sDoc).getDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning");
                    TestStructuredPartitionerXML.assertTrue((String)"partitioner doesn't implement IStructuredTextPartitioner", (boolean)(partitioner instanceof IStructuredTextPartitioner));
                    IStructuredTextPartitioner stp = (IStructuredTextPartitioner)partitioner;
                    TestStructuredPartitionerXML.assertNotNull((String)("partitioner was null for sDoc:" + sDoc), (Object)partitioner);
                    try {
                        stp.disconnect();
                    }
                    catch (Exception e) {
                        TestStructuredPartitionerXML.assertTrue((String)("problem disconnecting w/:" + sDoc + "/n" + e), (boolean)false);
                    }
                    try {
                        stp.connect((IDocument)sDoc);
                    }
                    catch (Exception e) {
                        TestStructuredPartitionerXML.assertTrue((String)("problem connecting w/:" + sDoc + "/n" + e), (boolean)false);
                    }
                    break block9;
                }
                TestStructuredPartitionerXML.assertTrue((String)"could not retrieve structured model", (boolean)false);
            }
            finally {
                if (model != null) {
                    model.releaseFromEdit();
                }
            }
        }
    }

    public void testGetDefaultPartitionType() {
        IStructuredModel model = null;
        try {
            model = this.getModelForEdit("testfiles/xml/example01.xml");
            if (model != null) {
                IStructuredDocument sDoc = model.getStructuredDocument();
                TestStructuredPartitionerXML.assertTrue((String)"sDoc implementation not instance of IDocumentExtension3", (boolean)(sDoc instanceof IDocumentExtension3));
                IDocumentPartitioner partitioner = ((IDocumentExtension3)sDoc).getDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning");
                TestStructuredPartitionerXML.assertTrue((String)"partitioner doesn't implement IStructuredTextPartitioner", (boolean)(partitioner instanceof IStructuredTextPartitioner));
                IStructuredTextPartitioner stp = (IStructuredTextPartitioner)partitioner;
                String defaultPartitionType = stp.getDefaultPartitionType();
                TestStructuredPartitionerXML.assertTrue((String)("wrong default partition type was: [" + defaultPartitionType + "] should be: [" + "org.eclipse.wst.xml.XML_DEFAULT" + "]"), (boolean)defaultPartitionType.equals("org.eclipse.wst.xml.XML_DEFAULT"));
            } else {
                TestStructuredPartitionerXML.assertTrue((String)"could not retrieve structured model", (boolean)false);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetPartitionType() {
        IStructuredModel model = null;
        try {
            model = this.getModelForEdit("testfiles/xml/example01.xml");
            if (model != null) {
                IStructuredDocument sDoc = model.getStructuredDocument();
                TestStructuredPartitionerXML.assertTrue((String)"sDoc implementation not instance of IDocumentExtension3", (boolean)(sDoc instanceof IDocumentExtension3));
                IDocumentPartitioner partitioner = ((IDocumentExtension3)sDoc).getDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning");
                TestStructuredPartitionerXML.assertTrue((String)"paritioner doesn't implement IStructuredTextPartitioner", (boolean)(partitioner instanceof IStructuredTextPartitioner));
                IStructuredTextPartitioner stp = (IStructuredTextPartitioner)partitioner;
                String defaultPartitionType = stp.getDefaultPartitionType();
                TestStructuredPartitionerXML.assertTrue((String)("wrong default partition type was: [" + defaultPartitionType + "] should be: [" + "org.eclipse.wst.xml.XML_DEFAULT" + "]"), (boolean)defaultPartitionType.equals("org.eclipse.wst.xml.XML_DEFAULT"));
            } else {
                TestStructuredPartitionerXML.assertTrue((String)"could not retrieve structured model", (boolean)false);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testXML1() throws IOException, BadLocationException {
        int expectedPartitions = 6;
        int nPartitions = this.doComputePartitioningTest("testfiles/xml/example01.xml");
        TestStructuredPartitionerXML.assertEquals((String)"wrong number of partitions", (int)expectedPartitions, (int)nPartitions);
        this.checkSeams();
        this.verifyPartitionTypes(this.partitions, new String[]{"org.eclipse.wst.xml.XML_PI", "org.eclipse.wst.xml.XML_DEFAULT", "org.eclipse.wst.xml.XML_DECL", "org.eclipse.wst.xml.XML_DEFAULT", "org.eclipse.wst.xml.XML_COMMENT", "org.eclipse.wst.xml.XML_DEFAULT"});
    }

    public void testEmpty() throws IOException, BadLocationException {
        int expectedPartitions = 1;
        int nPartitions = this.doComputePartitioningTest("testfiles/xml/empty.xml");
        TestStructuredPartitionerXML.assertEquals((String)"wrong number of partitions", (int)expectedPartitions, (int)nPartitions);
        this.checkSeams();
        this.verifyPartitionTypes(this.partitions, new String[]{"org.eclipse.wst.xml.XML_DEFAULT"});
    }

    public void testPerfXML() throws IOException, BadLocationException {
        int expectedPartitions = 6;
        int nPartitions = this.doTimedComputePartitioningTest("testfiles/xml/company300k.xml");
        TestStructuredPartitionerXML.assertEquals((String)"wrong number of partitions", (int)expectedPartitions, (int)nPartitions);
        this.checkSeams();
        this.verifyPartitionTypes(this.partitions, new String[]{"org.eclipse.wst.xml.XML_PI", "org.eclipse.wst.xml.XML_DEFAULT", "org.eclipse.wst.xml.XML_DECL", "org.eclipse.wst.xml.XML_DEFAULT", "org.eclipse.wst.xml.XML_COMMENT", "org.eclipse.wst.xml.XML_DEFAULT"});
    }

    protected void checkSeams() {
        if (this.partitions == null) {
            return;
        }
        int offset = 0;
        int i = 0;
        while (i < this.partitions.length) {
            TestStructuredPartitionerXML.assertEquals((String)"partitions are not contiguous!", (int)offset, (int)this.partitions[i].getOffset());
            offset = this.partitions[i].getOffset() + this.partitions[i].getLength();
            ++i;
        }
    }

    protected int doComputePartitioningTest(String filename) throws IOException, BadLocationException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        if (inStream == null) {
            inStream = new NullStream();
        }
        IStructuredModel model = modelManager.getModelForEdit(filename, inStream, null);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (this.DEBUG_PRINT_RESULT && this.useFormatter) {
            double baseTen = Math.log(10.0);
            this.formatter.setMinimumIntegerDigits((int)(Math.log(structuredDocument.getLength()) / baseTen) + 1);
            this.formatter.setGroupingUsed(false);
        }
        this.partitions = structuredDocument.computePartitioning(0, structuredDocument.getLength());
        if (this.DEBUG_PRINT_RESULT) {
            String contents = null;
            System.out.println("\nfilename: " + filename);
            int i = 0;
            while (i < this.partitions.length) {
                try {
                    contents = structuredDocument.get(this.partitions[i].getOffset(), this.partitions[i].getLength());
                }
                catch (BadLocationException badLocationException) {
                    contents = "*error*";
                }
                if (this.useFormatter) {
                    System.out.println(String.valueOf(this.formatter.format((long)this.partitions[i].getOffset())) + ":" + this.formatter.format((long)this.partitions[i].getLength()) + " - " + this.partitions[i].getType() + " [" + StringUtils.escape((String)contents) + "]");
                } else {
                    System.out.println(this.partitions[i] + " [" + StringUtils.escape((String)contents) + "]");
                }
                ++i;
            }
        }
        this.checkSeams();
        model.releaseFromEdit();
        inStream.close();
        if (this.partitions == null) {
            return -1;
        }
        return this.partitions.length;
    }

    protected ITypedRegion getPartitionTest(String filename, int offset) throws IOException, BadLocationException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        IStructuredModel model = modelManager.getModelForEdit(filename, inStream, null);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        this.partitions = null;
        ITypedRegion partition = structuredDocument.getPartition(offset);
        if (this.DEBUG_PRINT_RESULT) {
            String contents = null;
            System.out.println("\nfilename: " + filename);
            try {
                contents = structuredDocument.get(partition.getOffset(), partition.getLength());
            }
            catch (BadLocationException badLocationException) {
                contents = "*error*";
            }
            System.out.println(partition + " [" + StringUtils.escape((String)contents) + "]");
        }
        model.releaseFromEdit();
        inStream.close();
        return partition;
    }

    protected void verifyPartitionTypes(ITypedRegion[] actualTypedRegions, String[] expectedTypes) {
        int i = 0;
        while (i < expectedTypes.length) {
            TestStructuredPartitionerXML.assertEquals((String)"partition type mismatched", (String)expectedTypes[i], (String)actualTypedRegions[i].getType());
            ++i;
        }
    }

    protected void verifyPartitionRegions(ITypedRegion[] typedRegions, int[] offsets) {
        int i = 0;
        while (i < offsets.length) {
            TestStructuredPartitionerXML.assertEquals((String)"offset mismatched", (int)typedRegions[i].getOffset(), (int)offsets[i]);
            if (i > 0) {
                TestStructuredPartitionerXML.assertEquals((String)"lengths misaligned", (int)typedRegions[i].getOffset(), (int)(typedRegions[i - 1].getOffset() + typedRegions[i - 1].getLength()));
            }
            ++i;
        }
    }

    protected int doTimedComputePartitioningTest(String filename) throws IOException, BadLocationException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        if (inStream == null) {
            inStream = new NullStream();
        }
        IStructuredModel model = modelManager.getModelForEdit(filename, inStream, null);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (this.DEBUG_PRINT_RESULT && this.useFormatter) {
            double baseTen = Math.log(10.0);
            this.formatter.setMinimumIntegerDigits((int)(Math.log(structuredDocument.getLength()) / baseTen) + 1);
            this.formatter.setGroupingUsed(false);
        }
        long startTime = System.currentTimeMillis();
        this.partitions = structuredDocument.computePartitioning(0, structuredDocument.getLength());
        long endTime = System.currentTimeMillis();
        if (this.DEBUG_PRINT_RESULT) {
            String contents = null;
            System.out.println("\nfilename: " + filename);
            System.out.println("Time to compute " + this.partitions.length + ": " + (endTime - startTime) + " (msecs)");
            int i = 0;
            while (i < this.partitions.length) {
                try {
                    contents = structuredDocument.get(this.partitions[i].getOffset(), this.partitions[i].getLength());
                }
                catch (BadLocationException badLocationException) {
                    contents = "*error*";
                }
                if (this.useFormatter) {
                    System.out.println(String.valueOf(this.formatter.format((long)this.partitions[i].getOffset())) + ":" + this.formatter.format((long)this.partitions[i].getLength()) + " - " + this.partitions[i].getType() + " [" + StringUtils.escape((String)contents) + "]");
                } else {
                    System.out.println(this.partitions[i] + " [" + StringUtils.escape((String)contents) + "]");
                }
                ++i;
            }
        }
        this.checkSeams();
        model.releaseFromEdit();
        inStream.close();
        if (this.partitions == null) {
            return -1;
        }
        return this.partitions.length;
    }
}

