/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.jpt.common.utility.collection.Bag;
import org.eclipse.jpt.common.utility.internal.collection.EmptyBag;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.collection.IdentityHashBag;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.collection.SynchronizedBag;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class CollectionTools {
    public static <E> boolean addAll(Collection<? super E> collection, Iterable<? extends E> iterable) {
        return CollectionTools.addAll(collection, iterable.iterator());
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.addAll(collection, iterable.iterator(), iterableSize);
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterator<? extends E> iterator) {
        return iterator.hasNext() && CollectionTools.addAll_(collection, iterator);
    }

    static <E> boolean addAll_(Collection<? super E> collection, Iterator<? extends E> iterator) {
        boolean modified = false;
        do {
            modified |= collection.add(iterator.next());
        } while (iterator.hasNext());
        return modified;
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterator<? extends E> iterator, int iteratorSize) {
        return iterator.hasNext() && collection.addAll(ListTools.arrayList(iterator, iteratorSize));
    }

    public static <E> boolean addAll(Collection<? super E> collection, E ... array) {
        return array.length != 0 && CollectionTools.addAll_(collection, array);
    }

    private static <E> boolean addAll_(Collection<? super E> collection, E ... array) {
        boolean modified = false;
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            modified |= collection.add(element);
            ++n2;
        }
        return modified;
    }

    public static boolean containsAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.containsAll(collection, iterable.iterator());
    }

    public static boolean containsAll(Collection<?> collection, Iterator<?> iterator) {
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection<?> collection, Object ... array) {
        int i = array.length;
        while (i-- > 0) {
            if (collection.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public static <E> HashBag<E> filter(Collection<? extends E> collection, Predicate<? super E> filter) {
        HashBag<E> result = CollectionTools.hashBag(collection.size());
        for (E e : collection) {
            if (!filter.evaluate(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <E> ArrayList<ArrayList<E>> partition(Collection<? extends E> collection, int count) {
        int j;
        ArrayList<E> partition;
        int i;
        if (count <= 0) {
            throw new IllegalArgumentException("count must be greater than zero: " + count);
        }
        int collectionSize = collection.size();
        if (collectionSize < count) {
            throw new IllegalArgumentException("collection size (" + collectionSize + ") must be greater than or equal to count: " + count);
        }
        int partitionSize = collectionSize / count;
        int remainder = collectionSize % count;
        Iterator<E> stream = collection.iterator();
        ArrayList result = new ArrayList(count);
        if (remainder != 0) {
            ++partitionSize;
            i = remainder;
            while (i-- > 0) {
                partition = new ArrayList(partitionSize);
                j = partitionSize;
                while (j-- > 0) {
                    partition.add(stream.next());
                }
                result.add(partition);
            }
            --partitionSize;
            count -= remainder;
        }
        i = count;
        while (i-- > 0) {
            partition = new ArrayList<E>(partitionSize);
            j = partitionSize;
            while (j-- > 0) {
                partition.add(stream.next());
            }
            result.add(partition);
        }
        return result;
    }

    public static boolean removeAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.removeAll(collection, iterable.iterator());
    }

    public static boolean removeAll(Collection<?> collection, Iterable<?> iterable, int iterableSize) {
        return CollectionTools.removeAll(collection, iterable.iterator(), iterableSize);
    }

    public static boolean removeAll(Collection<?> collection, Iterator<?> iterator) {
        return iterator.hasNext() && collection.removeAll(CollectionTools.hashSet(iterator));
    }

    public static boolean removeAll(Collection<?> collection, Iterator<?> iterator, int iteratorSize) {
        return iterator.hasNext() && collection.removeAll(CollectionTools.hashSet(iterator, iteratorSize));
    }

    public static boolean removeAll(Collection<?> collection, Object ... array) {
        return array.length != 0 && collection.removeAll(CollectionTools.hashSet(array));
    }

    /*
     * Unable to fully structure code
     */
    public static boolean removeAllOccurrences(Collection<?> collection, Object value) {
        block2: {
            modified = false;
            stream = collection.iterator();
            if (value != null) ** GOTO lbl13
            while (stream.hasNext()) {
                if (stream.next() != null) continue;
                stream.remove();
                modified = true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(stream.next())) continue;
                stream.remove();
                modified = true;
lbl13:
                // 3 sources

                ** while (stream.hasNext())
            }
        }
        return modified;
    }

    public static boolean retainAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.retainAll(collection, iterable.iterator());
    }

    public static boolean retainAll(Collection<?> collection, Iterable<?> iterable, int iterableSize) {
        return CollectionTools.retainAll(collection, iterable.iterator(), iterableSize);
    }

    public static boolean retainAll(Collection<?> collection, Iterator<?> iterator) {
        if (iterator.hasNext()) {
            return collection.retainAll(CollectionTools.hashSet(iterator));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Iterator<?> iterator, int iteratorSize) {
        if (iterator.hasNext()) {
            return collection.retainAll(CollectionTools.hashSet(iterator, iteratorSize));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Object ... array) {
        if (array.length > 0) {
            return collection.retainAll(CollectionTools.hashSet(array));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static <E> E[] toArray(Collection<? extends E> collection, Class<E> clazz) {
        return collection.toArray((Object[])Array.newInstance(clazz, collection.size()));
    }

    public static <E1, E2> HashBag<E2> transform(Collection<E1> collection, Transformer<? super E1, ? extends E2> transformer) {
        HashBag<E2> result = CollectionTools.hashBag(collection.size());
        for (E1 e : collection) {
            result.add(transformer.transform(e));
        }
        return result;
    }

    public static <E> HashBag<E> hashBag() {
        return new HashBag();
    }

    public static <E> HashBag<E> hashBag(int initialCapacity) {
        return new HashBag(initialCapacity);
    }

    public static <E> HashBag<E> hashBag(int initialCapacity, float loadFactor) {
        return new HashBag(initialCapacity, loadFactor);
    }

    public static <E> HashBag<E> hashBag(Iterable<? extends E> iterable) {
        return CollectionTools.hashBag(iterable.iterator());
    }

    public static <E> HashBag<E> hashBag(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.hashBag(iterable.iterator(), iterableSize);
    }

    public static <E> HashBag<E> hashBag(Iterator<? extends E> iterator) {
        HashBag<E> bag = CollectionTools.hashBag();
        return CollectionTools.hashBag(iterator, bag);
    }

    public static <E> HashBag<E> hashBag(Iterator<? extends E> iterator, int iteratorSize) {
        HashBag<E> bag = CollectionTools.hashBag(iteratorSize);
        return CollectionTools.hashBag(iterator, bag);
    }

    private static <E> HashBag<E> hashBag(Iterator<? extends E> iterator, HashBag<E> bag) {
        while (iterator.hasNext()) {
            bag.add(iterator.next());
        }
        return bag;
    }

    public static <E> HashBag<E> hashBag(E ... array) {
        int len = array.length;
        HashBag<E> bag = CollectionTools.hashBag(len);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            bag.add(item);
            ++n2;
        }
        return bag;
    }

    public static <E> SynchronizedBag<E> synchronizedBag() {
        HashBag<E> bag = CollectionTools.hashBag();
        return CollectionTools.synchronizedBag(bag);
    }

    public static <E> SynchronizedBag<E> synchronizedBag(Object mutex) {
        HashBag<E> bag = CollectionTools.hashBag();
        return CollectionTools.synchronizedBag(bag, mutex);
    }

    public static <E> SynchronizedBag<E> synchronizedBag(Bag<E> bag) {
        return new SynchronizedBag<E>(bag);
    }

    public static <E> SynchronizedBag<E> synchronizedBag(Bag<E> bag, Object mutex) {
        return new SynchronizedBag<E>(bag, mutex);
    }

    public static <E> Bag<E> emptyBag() {
        return EmptyBag.instance();
    }

    public static <E> IdentityHashBag<E> identityHashBag() {
        return new IdentityHashBag();
    }

    public static <E> IdentityHashBag<E> identityHashBag(int initialCapacity) {
        return new IdentityHashBag(initialCapacity);
    }

    public static <E> IdentityHashBag<E> identityHashBag(int initialCapacity, float loadFactor) {
        return new IdentityHashBag(initialCapacity, loadFactor);
    }

    public static <E> IdentityHashBag<E> identityHashBag(Iterable<? extends E> iterable) {
        return CollectionTools.identityHashBag(iterable.iterator());
    }

    public static <E> IdentityHashBag<E> identityHashBag(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.identityHashBag(iterable.iterator(), iterableSize);
    }

    public static <E> IdentityHashBag<E> identityHashBag(Iterator<? extends E> iterator) {
        IdentityHashBag<E> bag = CollectionTools.identityHashBag();
        return CollectionTools.identityHashBag(iterator, bag);
    }

    public static <E> IdentityHashBag<E> identityHashBag(Iterator<? extends E> iterator, int iteratorSize) {
        IdentityHashBag<E> bag = CollectionTools.identityHashBag(iteratorSize);
        return CollectionTools.identityHashBag(iterator, bag);
    }

    private static <E> IdentityHashBag<E> identityHashBag(Iterator<? extends E> iterator, IdentityHashBag<E> bag) {
        while (iterator.hasNext()) {
            bag.add(iterator.next());
        }
        return bag;
    }

    public static <E> IdentityHashBag<E> identityHashBag(E ... array) {
        int len = array.length;
        IdentityHashBag<E> bag = CollectionTools.identityHashBag(len);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            bag.add(item);
            ++n2;
        }
        return bag;
    }

    public static <E> HashSet<E> hashSet(Iterable<? extends E> iterable) {
        return CollectionTools.hashSet(iterable.iterator());
    }

    public static <E> HashSet<E> hashSet(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.hashSet(iterable.iterator(), iterableSize);
    }

    public static <E> HashSet<E> hashSet(Iterator<? extends E> iterator) {
        return CollectionTools.hashSet(iterator, new HashSet());
    }

    public static <E> HashSet<E> hashSet(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.hashSet(iterator, new HashSet(iteratorSize));
    }

    private static <E> HashSet<E> hashSet(Iterator<? extends E> iterator, HashSet<E> set) {
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <E> HashSet<E> hashSet(E ... array) {
        HashSet<E> set = new HashSet<E>(array.length);
        int i = array.length;
        while (i-- > 0) {
            set.add(array[i]);
        }
        return set;
    }

    public static <E extends Comparable<? super E>> TreeSet<E> treeSet(Iterable<? extends E> iterable) {
        return CollectionTools.treeSet(iterable.iterator());
    }

    public static <E extends Comparable<? super E>> TreeSet<E> treeSet(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.treeSet(iterable.iterator(), iterableSize);
    }

    public static <E> TreeSet<E> treeSet(Iterable<? extends E> iterable, Comparator<? super E> comparator) {
        return CollectionTools.treeSet(iterable.iterator(), comparator);
    }

    public static <E> TreeSet<E> treeSet(Iterable<? extends E> iterable, Comparator<? super E> comparator, int iterableSize) {
        return CollectionTools.treeSet(iterable.iterator(), comparator, iterableSize);
    }

    public static <E extends Comparable<? super E>> TreeSet<E> treeSet(Iterator<? extends E> iterator) {
        return CollectionTools.treeSet(iterator, null);
    }

    public static <E extends Comparable<? super E>> TreeSet<E> treeSet(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.treeSet(iterator, null, iteratorSize);
    }

    public static <E> TreeSet<E> treeSet(Iterator<? extends E> iterator, Comparator<? super E> comparator) {
        return CollectionTools.treeSet(ListTools.arrayList(iterator), comparator);
    }

    public static <E> TreeSet<E> treeSet(Iterator<? extends E> iterator, Comparator<? super E> comparator, int iteratorSize) {
        return CollectionTools.treeSet(ListTools.arrayList(iterator, iteratorSize), comparator);
    }

    private static <E> TreeSet<E> treeSet(ArrayList<E> list, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(list);
        return sortedSet;
    }

    public static <E extends Comparable<? super E>> TreeSet<E> treeSet(E ... array) {
        return CollectionTools.treeSet(array, null);
    }

    public static <E> TreeSet<E> treeSet(E[] array, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(Arrays.asList(array));
        return sortedSet;
    }

    public static <E> Vector<E> vector(Iterable<? extends E> iterable) {
        return CollectionTools.vector(iterable.iterator());
    }

    public static <E> Vector<E> vector(Iterable<? extends E> iterable, int size) {
        return CollectionTools.vector(iterable.iterator(), size);
    }

    public static <E> Vector<E> vector(Iterator<? extends E> iterator) {
        return CollectionTools.vector(iterator, new Vector());
    }

    public static <E> Vector<E> vector(Iterator<? extends E> iterator, int size) {
        return CollectionTools.vector(iterator, new Vector(size));
    }

    private static <E> Vector<E> vector(Iterator<? extends E> iterator, Vector<E> v) {
        while (iterator.hasNext()) {
            v.addElement(iterator.next());
        }
        return v;
    }

    public static <E> Vector<E> vector(E ... array) {
        Vector<E> v = new Vector<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            v.addElement(item);
            ++n2;
        }
        return v;
    }

    private CollectionTools() {
        throw new UnsupportedOperationException();
    }
}

