/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.dialogs;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.internal.dialogs.Messages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.server.core.IRuntime;

public class RuntimeSelectionDialog
extends MessageDialog {
    private IProject project = null;
    private String configuredMessage;

    public RuntimeSelectionDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, IProject project) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.project = project;
        this.configuredMessage = MessageFormat.format(J2EEUIMessages.getResourceString("DEPLOY_RUNTIME_CONFIGURED"), project.getName());
    }

    protected Control createCustomArea(Composite parent) {
        this.createHyperLink(parent);
        return parent;
    }

    private void createHyperLink(Composite parent) {
        Hyperlink link = new Hyperlink(parent, 0);
        GridData layout = new GridData(128);
        layout.horizontalSpan = 2;
        link.setLayoutData((Object)layout);
        link.setUnderlined(true);
        Color color = new Color((Device)parent.getDisplay(), new RGB(0, 0, 255));
        link.setForeground(color);
        link.setText(Messages.RuntimeSelectionDialog_Configure_Target_Runtime_);
        link.addHyperlinkListener(new IHyperlinkListener(){
            public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                String id = this.getPreferencePageID();
                PreferencesUtil.createPropertyDialogOn((Shell)RuntimeSelectionDialog.this.getShell(), (IAdaptable)RuntimeSelectionDialog.this.project, (String)id, (String[])new String[]{id}, (Object)DATA_NO_LINK).open();
                try {
                    RuntimeSelectionDialog.this.updateWidgets();
                }
                catch (Exception exception) {}
            }

            private String getPreferencePageID() {
                return "org.eclipse.wst.common.project.facet.ui.internal.RuntimesPropertyPage";
            }
        });
    }

    private void updateWidgets() {
        if (this.getTargetRuntime() != null) {
            this.messageLabel.setText(this.configuredMessage);
            this.imageLabel.setImage(this.getInfoImage());
        } else {
            this.messageLabel.setText(this.message);
            this.imageLabel.setImage(this.getErrorImage());
        }
    }

    private IRuntime getTargetRuntime() {
        try {
            IRuntime runtime = J2EEProjectUtilities.getServerRuntime((IProject)this.project);
            return runtime;
        }
        catch (CoreException e) {
            J2EEUIPlugin.logError(e);
            return null;
        }
    }
}

