/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.MapTypes;
import org.eclipse.jem.internal.proxy.core.Expression;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IProxyBeanType;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.ide.IDEArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBigDecimalBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBigIntegerBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBooleanClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBooleanTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEByteClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEByteTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDECharTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDECharacterClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEDoubleClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEDoubleTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEExpression;
import org.eclipse.jem.internal.proxy.ide.IDEExtensionBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEFloatClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEFloatTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEInitErrorBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEIntegerClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEIntegerTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDELongClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDELongTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEShortClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEShortTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEStringBeanTypeProxy;

public class IDEStandardBeanTypeProxyFactory
implements IStandardBeanTypeProxyFactory {
    protected final IDEProxyFactoryRegistry fFactoryRegistry;
    protected Map beanProxies;
    public static Map MAP_SHORTSIG_TO_TYPE = new HashMap(8);
    public static Map MAP_TYPENAME_TO_SHORTSIG = new HashMap(8);
    IDEBeanTypeProxy objectClass;
    IDEBooleanTypeBeanTypeProxy booleanType;
    IDEBooleanClassBeanTypeProxy booleanClass;
    IDEIntegerTypeBeanTypeProxy intType;
    IDEIntegerClassBeanTypeProxy integerClass;
    IDEFloatTypeBeanTypeProxy floatType;
    IDEFloatClassBeanTypeProxy floatClass;
    IDELongTypeBeanTypeProxy longType;
    IDELongClassBeanTypeProxy longClass;
    IDEShortTypeBeanTypeProxy shortType;
    IDEShortClassBeanTypeProxy shortClass;
    IDEByteTypeBeanTypeProxy byteType;
    IDEByteClassBeanTypeProxy byteClass;
    IDECharTypeBeanTypeProxy charType;
    IDECharacterClassBeanTypeProxy charClass;
    IDEDoubleTypeBeanTypeProxy doubleType;
    IDEDoubleClassBeanTypeProxy doubleClass;
    IDEStringBeanTypeProxy stringClass;
    IDEClassBeanTypeProxy classClass;
    IDEBeanTypeProxy voidType;

    static {
        MAP_SHORTSIG_TO_TYPE.put("B", Byte.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("C", Character.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("D", Double.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("F", Float.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("I", Integer.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("J", Long.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("S", Short.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("Z", Boolean.TYPE);
        MAP_TYPENAME_TO_SHORTSIG.put("byte", "B");
        MAP_TYPENAME_TO_SHORTSIG.put("char", "C");
        MAP_TYPENAME_TO_SHORTSIG.put("double", "D");
        MAP_TYPENAME_TO_SHORTSIG.put("float", "F");
        MAP_TYPENAME_TO_SHORTSIG.put("int", "I");
        MAP_TYPENAME_TO_SHORTSIG.put("long", "J");
        MAP_TYPENAME_TO_SHORTSIG.put("short", "S");
        MAP_TYPENAME_TO_SHORTSIG.put("boolean", "Z");
    }

    public IDEStandardBeanTypeProxyFactory(IDEProxyFactoryRegistry aRegistry) {
        this.fFactoryRegistry = aRegistry;
        aRegistry.registerBeanTypeProxyFactory(this);
        this.objectClass = new IDEBeanTypeProxy(this.fFactoryRegistry, Object.class);
        this.booleanType = new IDEBooleanTypeBeanTypeProxy(this.fFactoryRegistry, Boolean.TYPE);
        this.booleanClass = new IDEBooleanClassBeanTypeProxy(this.fFactoryRegistry, Boolean.class);
        this.intType = new IDEIntegerTypeBeanTypeProxy(this.fFactoryRegistry, Integer.TYPE);
        this.integerClass = new IDEIntegerClassBeanTypeProxy(this.fFactoryRegistry, Integer.class);
        this.floatType = new IDEFloatTypeBeanTypeProxy(this.fFactoryRegistry, Float.TYPE);
        this.floatClass = new IDEFloatClassBeanTypeProxy(this.fFactoryRegistry, Float.class);
        this.longType = new IDELongTypeBeanTypeProxy(this.fFactoryRegistry, Long.TYPE);
        this.longClass = new IDELongClassBeanTypeProxy(this.fFactoryRegistry, Long.class);
        this.shortType = new IDEShortTypeBeanTypeProxy(this.fFactoryRegistry, Short.TYPE);
        this.shortClass = new IDEShortClassBeanTypeProxy(this.fFactoryRegistry, Short.class);
        this.byteType = new IDEByteTypeBeanTypeProxy(this.fFactoryRegistry, Byte.TYPE);
        this.byteClass = new IDEByteClassBeanTypeProxy(this.fFactoryRegistry, Byte.class);
        this.charType = new IDECharTypeBeanTypeProxy(this.fFactoryRegistry, Character.TYPE);
        this.charClass = new IDECharacterClassBeanTypeProxy(this.fFactoryRegistry, Character.class);
        this.doubleType = new IDEDoubleTypeBeanTypeProxy(this.fFactoryRegistry, Double.TYPE);
        this.doubleClass = new IDEDoubleClassBeanTypeProxy(this.fFactoryRegistry, Double.class);
        this.stringClass = new IDEStringBeanTypeProxy(this.fFactoryRegistry, String.class);
        this.classClass = new IDEClassBeanTypeProxy(this.fFactoryRegistry, Class.class);
        this.voidType = new IDEBeanTypeProxy(this.fFactoryRegistry, Void.TYPE);
        this.beanProxies = new HashMap(20);
        this.beanProxies.put(this.intType.getTypeName(), this.intType);
        this.beanProxies.put(this.booleanType.getTypeName(), this.booleanType);
        this.beanProxies.put(this.charType.getTypeName(), this.charType);
        this.beanProxies.put(this.byteType.getTypeName(), this.byteType);
        this.beanProxies.put(this.shortType.getTypeName(), this.shortType);
        this.beanProxies.put(this.longType.getTypeName(), this.longType);
        this.beanProxies.put(this.floatType.getTypeName(), this.floatType);
        this.beanProxies.put(this.doubleType.getTypeName(), this.doubleType);
        this.beanProxies.put(this.integerClass.getTypeName(), this.integerClass);
        this.beanProxies.put(this.booleanClass.getTypeName(), this.booleanClass);
        this.beanProxies.put(this.charClass.getTypeName(), this.charClass);
        this.beanProxies.put(this.byteClass.getTypeName(), this.byteClass);
        this.beanProxies.put(this.shortClass.getTypeName(), this.shortClass);
        this.beanProxies.put(this.longClass.getTypeName(), this.longClass);
        this.beanProxies.put(this.floatClass.getTypeName(), this.floatClass);
        this.beanProxies.put(this.doubleClass.getTypeName(), this.doubleClass);
        this.beanProxies.put(BigDecimal.class.getName(), new IDEBigDecimalBeanTypeProxy(this.fFactoryRegistry, BigDecimal.class));
        this.beanProxies.put(BigInteger.class.getName(), new IDEBigIntegerBeanTypeProxy(this.fFactoryRegistry, BigInteger.class));
        this.beanProxies.put(this.stringClass.getTypeName(), this.stringClass);
        this.beanProxies.put(this.classClass.getTypeName(), this.classClass);
        this.beanProxies.put(this.voidType.getTypeName(), this.voidType);
    }

    IBeanTypeProxy getBeanTypeProxy(Class anIDEClass) {
        return this.getBeanTypeProxy(anIDEClass.getName());
    }

    @Override
    public synchronized IBeanTypeProxy getBeanTypeProxy(String typeName) {
        IProxyBeanType beanTypeProxy = (IProxyBeanType)this.beanProxies.get(typeName = MapTypes.getJNIFormatName(typeName));
        if (beanTypeProxy != null && beanTypeProxy.isBeanProxy()) {
            return (IBeanTypeProxy)beanTypeProxy;
        }
        if (typeName.charAt(0) != '[') {
            String msg;
            String packageName;
            IDEExtensionBeanTypeProxyFactory packageFactory;
            int packageIndex = typeName.lastIndexOf(46);
            if (packageIndex != -1 && (packageFactory = (IDEExtensionBeanTypeProxyFactory)this.fFactoryRegistry.getBeanTypeProxyFactoryExtension(packageName = typeName.substring(0, packageIndex))) != null && (beanTypeProxy = packageFactory.getExtensionBeanTypeProxy(typeName)) != null) {
                this.registerBeanTypeProxy((IBeanTypeProxy)beanTypeProxy, false);
                return (IBeanTypeProxy)beanTypeProxy;
            }
            try {
                Class ideClass = this.fFactoryRegistry.loadClass(typeName);
                IDEBeanTypeProxy superTypeProxy = null;
                if (ideClass.getSuperclass() != null) {
                    superTypeProxy = (IDEBeanTypeProxy)this.getBeanTypeProxy(ideClass.getSuperclass());
                }
                if (superTypeProxy != null) {
                    beanTypeProxy = superTypeProxy.newBeanTypeForClass(ideClass);
                }
                if (beanTypeProxy == null) {
                    beanTypeProxy = new IDEBeanTypeProxy(this.fFactoryRegistry, ideClass);
                }
            }
            catch (ClassNotFoundException e) {
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(1, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                msg = MessageFormat.format("{0}({1})", e.getClass(), e.getMessage());
                beanTypeProxy = new IDEInitErrorBeanTypeProxy(this.fFactoryRegistry, typeName, msg, e);
            }
            catch (ExceptionInInitializerError e) {
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                msg = MessageFormat.format("{0}({1})", e.getClass(), e.getMessage());
                beanTypeProxy = new IDEInitErrorBeanTypeProxy(this.fFactoryRegistry, typeName, msg, e.getCause());
            }
            catch (LinkageError e) {
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                msg = MessageFormat.format("{0}({1})", e.getClass(), e.getMessage());
                beanTypeProxy = new IDEInitErrorBeanTypeProxy(this.fFactoryRegistry, typeName, msg, e);
            }
            this.beanProxies.put(typeName, beanTypeProxy);
            return (IBeanTypeProxy)beanTypeProxy;
        }
        int dims = typeName.lastIndexOf(91) + 1;
        Class finalComponentType = null;
        if (typeName.charAt(dims) == 'L') {
            IDEBeanTypeProxy finalType = (IDEBeanTypeProxy)this.getBeanTypeProxy(typeName.substring(dims + 1, typeName.length() - 1));
            if (finalType != null) {
                finalComponentType = finalType.fClass;
            }
        } else {
            finalComponentType = (Class)MAP_SHORTSIG_TO_TYPE.get(typeName.substring(dims, dims + 1));
        }
        if (finalComponentType != null) {
            Object dummyArray = Array.newInstance(finalComponentType, new int[dims]);
            beanTypeProxy = new IDEArrayBeanTypeProxy(this.fFactoryRegistry, typeName, dummyArray.getClass());
            this.beanProxies.put(typeName, beanTypeProxy);
        }
        return (IBeanTypeProxy)beanTypeProxy;
    }

    @Override
    public synchronized IProxyBeanType getBeanTypeProxy(IExpression expression, String typeName) {
        String packageName;
        IDEExtensionBeanTypeProxyFactory packageFactory;
        int packageIndex;
        IProxyBeanType beanTypeProxy = (IProxyBeanType)this.beanProxies.get(typeName = MapTypes.getJNIFormatName(typeName));
        if (beanTypeProxy != null) {
            return beanTypeProxy;
        }
        beanTypeProxy = ((IDEExpression)expression).getBeanType(typeName);
        if (beanTypeProxy != null) {
            return beanTypeProxy;
        }
        if (typeName.charAt(0) != '[' && (packageIndex = typeName.lastIndexOf(46)) != -1 && (packageFactory = (IDEExtensionBeanTypeProxyFactory)this.fFactoryRegistry.getBeanTypeProxyFactoryExtension(packageName = typeName.substring(0, packageIndex))) != null && (beanTypeProxy = packageFactory.getExtensionBeanTypeProxy(typeName, expression)) != null) {
            this.registerBeanTypeProxy(beanTypeProxy, false);
            return beanTypeProxy;
        }
        beanTypeProxy = ((Expression)expression).createBeanTypeExpressionProxy(typeName);
        this.registerBeanTypeProxy(beanTypeProxy, false);
        return beanTypeProxy;
    }

    @Override
    public IBeanTypeProxy getBeanTypeProxy(String componentClassName, int dimensions) {
        return this.getBeanTypeProxy(this.getArrayClassname(componentClassName, dimensions));
    }

    @Override
    public IProxyBeanType getBeanTypeProxy(IExpression expression, String componentClassName, int dimensions) {
        return this.getBeanTypeProxy(expression, this.getArrayClassname(componentClassName, dimensions));
    }

    protected String getArrayClassname(String componentClassName, int dimensions) {
        String jniComponentTypeName;
        String compType = jniComponentTypeName = MapTypes.getJNIFormatName(componentClassName);
        if (jniComponentTypeName.charAt(0) != '[' && (compType = (String)MAP_TYPENAME_TO_SHORTSIG.get(componentClassName)) == null) {
            compType = "L" + jniComponentTypeName + ";";
        }
        StringBuffer buffer = new StringBuffer(dimensions + compType.length());
        int i = 0;
        while (i < dimensions) {
            buffer.append('[');
            ++i;
        }
        buffer.append(compType);
        return buffer.toString();
    }

    @Override
    public void terminateFactory(boolean wait) {
    }

    @Override
    public synchronized void registerBeanTypeProxy(IBeanTypeProxy aBeanTypeProxy, boolean permanent) {
        this.beanProxies.put(aBeanTypeProxy.getTypeName(), aBeanTypeProxy);
    }

    @Override
    public void registerBeanTypeProxy(IProxyBeanType aProxyBeanType, boolean permanent) {
        if (aProxyBeanType.isBeanProxy()) {
            this.registerBeanTypeProxy((IBeanTypeProxy)aProxyBeanType, permanent);
        } else {
            ExpressionProxy beanExpressionProxy = (ExpressionProxy)((Object)aProxyBeanType);
            final String typeName = aProxyBeanType.getTypeName();
            ((IDEExpression)beanExpressionProxy.getExpression()).addBeanType(typeName, aProxyBeanType);
            beanExpressionProxy.addProxyListener(new ExpressionProxy.ProxyAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                    String typeName2 = ((IProxyBeanType)event.getSource()).getTypeName();
                    IDEStandardBeanTypeProxyFactory iDEStandardBeanTypeProxyFactory = IDEStandardBeanTypeProxyFactory.this;
                    synchronized (iDEStandardBeanTypeProxyFactory) {
                        if (!IDEStandardBeanTypeProxyFactory.this.beanProxies.containsKey(typeName2)) {
                            IDEStandardBeanTypeProxyFactory.this.beanProxies.put(typeName2, event.getProxy());
                        }
                    }
                }

                @Override
                public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                    ((IDEExpression)((ExpressionProxy)event.getSource()).getExpression()).removeBeanType(typeName);
                }
            });
        }
    }

    @Override
    public synchronized boolean isBeanTypeRegistered(String className) {
        return this.beanProxies.containsKey(MapTypes.getJNIFormatName(className));
    }

    @Override
    public Set registeredTypes() {
        return this.beanProxies.keySet();
    }

    @Override
    public boolean isBeanTypeNotFound(String className) {
        return false;
    }

    @Override
    public boolean isMaintainNotFoundTypes() {
        return false;
    }

    @Override
    public void setMaintainNotFoundTypes(boolean maintain) {
    }
}

