/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.CreateTypeMemberOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CreateMethodOperation
extends CreateTypeMemberOperation {
    protected String[] parameterTypes;

    public CreateMethodOperation(IJavaScriptElement parentElement, String source, boolean force) {
        super(parentElement, source, force);
    }

    protected String[] convertASTMethodTypesToSignatures() {
        if (this.parameterTypes == null && this.createdNode != null) {
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)this.createdNode;
            List parameters = methodDeclaration.parameters();
            int size = parameters.size();
            this.parameterTypes = new String[size];
            Iterator iterator = parameters.iterator();
            int i = 0;
            while (i < size) {
                SingleVariableDeclaration parameter = (SingleVariableDeclaration)iterator.next();
                String typeSig = Util.getSignature(parameter.getType());
                int extraDimensions = parameter.getExtraDimensions();
                if (methodDeclaration.isVarargs() && i == size - 1) {
                    ++extraDimensions;
                }
                this.parameterTypes[i] = Signature.createArraySignature(typeSig, extraDimensions);
                ++i;
            }
        }
        return this.parameterTypes;
    }

    @Override
    protected ASTNode generateElementAST(ASTRewrite rewriter, IDocument document, IJavaScriptUnit cu) throws JavaScriptModelException {
        ASTNode node = super.generateElementAST(rewriter, document, cu);
        if (node.getNodeType() != 31) {
            throw new JavaScriptModelException(new JavaModelStatus(984));
        }
        return node;
    }

    @Override
    protected IJavaScriptElement generateResultHandle() {
        String[] types = this.convertASTMethodTypesToSignatures();
        String name = this.getASTNodeName();
        if (this.getType() != null) {
            return this.getType().getFunction(name, types);
        }
        return this.getCompilationUnit().getFunction(name, types);
    }

    private String getASTNodeName() {
        return ((FunctionDeclaration)this.createdNode).getName().getIdentifier();
    }

    @Override
    public String getMainTaskName() {
        return Messages.operation_createMethodProgress;
    }

    @Override
    protected SimpleName rename(ASTNode node, SimpleName newName) {
        FunctionDeclaration method = (FunctionDeclaration)node;
        SimpleName oldName = method.getName();
        method.setName(newName);
        return oldName;
    }

    @Override
    protected IJavaScriptModelStatus verifyNameCollision() {
        if (this.createdNode != null) {
            IType type = this.getType();
            String name = ((FunctionDeclaration)this.createdNode).isConstructor() ? type.getElementName() : this.getASTNodeName();
            String[] types = this.convertASTMethodTypesToSignatures();
            if (type != null ? type.getFunction(name, types).exists() : this.getCompilationUnit().getFunction(name, types).exists()) {
                return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, name));
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

