/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.transformer;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.io.FileTools;
import org.eclipse.jpt.common.utility.internal.transformer.XMLStringDecoder;
import org.eclipse.jpt.common.utility.internal.transformer.XMLStringEncoder;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class XMLStringDecoderTests
extends TestCase {
    public XMLStringDecoderTests(String name) {
        super(name);
    }

    public void testDenormalizeValidFileName() {
        Transformer decoder = XMLStringDecoder.instance();
        String s = "foo";
        XMLStringDecoderTests.assertEquals((String)s, (String)((String)decoder.transform((Object)s)));
        s = "123foo123";
        XMLStringDecoderTests.assertEquals((String)s, (String)((String)decoder.transform((Object)s)));
    }

    public void testDenormalizeInvalidFileName() {
        Transformer decoder = XMLStringDecoder.instance();
        String s = "&#x3f;foo&#x3f;";
        String expected = "?foo?";
        XMLStringDecoderTests.assertEquals((String)expected, (String)((String)decoder.transform((Object)s)));
        s = "&#x3f;foo&#x26;123";
        expected = "?foo&123";
        XMLStringDecoderTests.assertEquals((String)expected, (String)((String)decoder.transform((Object)s)));
    }

    public void testRoundTripNoCharacterSequences() {
        this.verifyRoundTrip("foo");
        this.verifyRoundTrip("123foo456");
    }

    public void testRoundTripCharacterSequences() {
        this.verifyRoundTrip("?foo?");
        this.verifyRoundTrip("?foo&123&&&&&&>>>>");
    }

    private void verifyRoundTrip(String s) {
        XMLStringEncoder encoder = new XMLStringEncoder(FileTools.INVALID_FILENAME_CHARACTERS);
        String actual = (String)encoder.transform((Object)s);
        Transformer decoder = XMLStringDecoder.instance();
        XMLStringDecoderTests.assertEquals((String)s, (String)((String)decoder.transform((Object)actual)));
    }

    public void testInvalidCharacterSequence1() {
        this.verifyIllegalStateException("foo&");
    }

    public void testInvalidCharacterSequence2() {
        this.verifyIllegalStateException("foo&#");
    }

    public void testInvalidCharacterSequence3() {
        this.verifyIllegalStateException("foo&#x");
    }

    public void testInvalidCharacterSequence4() {
        this.verifyIllegalStateException("foo&#x3");
    }

    public void testInvalidCharacterSequence5() {
        this.verifyIllegalStateException("foo&#x;");
    }

    public void testInvalidCharacterSequence6() {
        this.verifyIllegalStateException("foo&A");
    }

    public void testInvalidCharacterSequence7() {
        this.verifyIllegalStateException("foo&#A");
    }

    private void verifyIllegalStateException(String s) {
        Transformer decoder = XMLStringDecoder.instance();
        boolean exCaught = false;
        try {
            s = (String)decoder.transform((Object)s);
            XMLStringDecoderTests.fail((String)s);
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        XMLStringDecoderTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidCharacterSequence8() {
        String s = "foo&#xZZZZ;";
        Transformer decoder = XMLStringDecoder.instance();
        boolean exCaught = false;
        try {
            s = (String)decoder.transform((Object)s);
            XMLStringDecoderTests.fail((String)s);
        }
        catch (NumberFormatException numberFormatException) {
            exCaught = true;
        }
        XMLStringDecoderTests.assertTrue((boolean)exCaught);
    }
}

