/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDOMRuntimeExtension;
import org.eclipse.jst.ws.jaxws.dom.runtime.internal.util.NamedExtensionInfo;
import org.eclipse.jst.ws.jaxws.dom.runtime.registry.IWsDOMRuntimeInfo;
import org.eclipse.jst.ws.jaxws.utils.logging.ILogger;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;

public class WsDOMRuntimeRegistry {
    private static final String RUNTIME_XP = "org.eclipse.jst.ws.jaxws.dom.runtime.domruntimes";
    public static final String EXTENSION_NOT_PROPERLY_REGISTERED = "Registered runtime extension not properly registered (error in plugin.xml)";
    private static final String XP_IMPLEMENTATION_ELEMENT = "implementation";
    private static final String XP_PROJECT_FACET_ELEMENT = "project_facet";
    private static final String XP_PROJECT_FACET_ID = "id";
    private static final String XP_PROJECT_FACET_VERSION = "version";
    private static final String XP_IMPLEMENTATION_ELEMENT_CLASS_ATTR = "class";

    public static IWsDOMRuntimeExtension instantiateRuntime(IWsDOMRuntimeInfo info) {
        IExtension ext = WsDOMRuntimeRegistry.findExtension(info);
        if (ext == null) {
            WsDOMRuntimeRegistry.logger().logError(EXTENSION_NOT_PROPERLY_REGISTERED);
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (el.getName().equals(XP_IMPLEMENTATION_ELEMENT)) {
                try {
                    Object impl = el.createExecutableExtension(XP_IMPLEMENTATION_ELEMENT_CLASS_ATTR);
                    if (impl instanceof IWsDOMRuntimeExtension) {
                        return (IWsDOMRuntimeExtension)impl;
                    }
                    return null;
                }
                catch (CoreException e) {
                    WsDOMRuntimeRegistry.logger().logError("Unable to create extension", (Throwable)e);
                    return null;
                }
            }
            ++n2;
        }
        WsDOMRuntimeRegistry.logger().logError(EXTENSION_NOT_PROPERLY_REGISTERED);
        throw new RuntimeException(EXTENSION_NOT_PROPERLY_REGISTERED);
    }

    public static IExtension findExtension(IWsDOMRuntimeInfo info) {
        if (info != null) {
            IExtension[] exts = Platform.getExtensionRegistry().getExtensionPoint(RUNTIME_XP).getExtensions();
            int i = 0;
            while (i < exts.length) {
                if (exts[i].getSimpleIdentifier().equals(info.getId())) {
                    return exts[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static Collection<IWsDOMRuntimeInfo> getRegisteredRuntimesInfo() {
        IExtension[] exts = Platform.getExtensionRegistry().getExtensionPoint(RUNTIME_XP).getExtensions();
        ArrayList<IWsDOMRuntimeInfo> runtimeDescriptors = new ArrayList<IWsDOMRuntimeInfo>(exts.length);
        int i = 0;
        while (i < exts.length) {
            HashMap<String, String> projectFacets = new HashMap<String, String>();
            IConfigurationElement[] iConfigurationElementArray = exts[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement el = iConfigurationElementArray[n2];
                if (el.getName().equals(XP_PROJECT_FACET_ELEMENT)) {
                    projectFacets.put(el.getAttribute(XP_PROJECT_FACET_ID), el.getAttribute(XP_PROJECT_FACET_VERSION));
                }
                ++n2;
            }
            runtimeDescriptors.add(new RuntimeInfo(exts[i].getSimpleIdentifier(), exts[i].getLabel(), projectFacets));
            ++i;
        }
        return runtimeDescriptors;
    }

    public static IWsDOMRuntimeInfo getRuntimeInfo(String runtimeId) {
        for (IWsDOMRuntimeInfo runtimeInfo : WsDOMRuntimeRegistry.getRegisteredRuntimesInfo()) {
            if (!runtimeInfo.getId().equals(runtimeId)) continue;
            return runtimeInfo;
        }
        return null;
    }

    private static ILogger logger() {
        return new Logger();
    }

    private static final class RuntimeInfo
    extends NamedExtensionInfo
    implements IWsDOMRuntimeInfo {
        private Map<String, String> projectFacets;

        RuntimeInfo(String pId, String pLabel, Map<String, String> projectFacets) {
            super(pId, pLabel);
            this.projectFacets = projectFacets;
        }

        @Override
        public Map<String, String> getProjectFacets() {
            return this.projectFacets;
        }
    }
}

