/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.InternalWSDLMultiPageEditor;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.actions.AddElementAction;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddImportAction
extends AddElementAction {
    protected String namespace;
    protected String location;
    protected String elementDeclarationNamespacePrefix;

    public AddImportAction(IEditorPart part, Definition definition, Node parentNode, String prefix) {
        this(part, definition, parentNode, prefix, null, null);
    }

    public AddImportAction(IEditorPart part, Definition definition, Node parentNode, String prefix, String namespace, String location) {
        super(Messages._UI_ACTION_ADD_IMPORT, "icons/import_obj.gif", parentNode, prefix, "import");
        this.setDefinition(definition);
        this.setComputeTopLevelRefChild(true);
        this.namespace = namespace;
        this.location = location;
        this.setEditorPart(part);
        if (part instanceof InternalWSDLMultiPageEditor) {
            this.document = ((IDOMModel)((InternalWSDLMultiPageEditor)part).getModel()).getDocument();
        }
    }

    @Override
    protected Element createElement(String nodeName) {
        Element definitionElement;
        if (this.elementDeclarationNamespacePrefix != null && this.namespace != null && (definitionElement = WSDLEditorUtil.getInstance().getElementForObject(this.definition)) != null) {
            definitionElement.setAttribute("xmlns:" + this.elementDeclarationNamespacePrefix, this.namespace);
        }
        return super.createElement(nodeName);
    }

    public void setElementDeclarationNamespacePrefix(String nsPrefix) {
        this.elementDeclarationNamespacePrefix = nsPrefix;
    }

    @Override
    protected void addAttributes(Element newElement) {
        newElement.setAttribute("namespace", this.namespace != null ? this.namespace : "");
        newElement.setAttribute("location", this.location != null ? this.location : "");
    }

    @Override
    public void performAddElement() {
        if (this.parentNode == null || this.document != null && this.document.getChildNodes().getLength() == 0) {
            this.createDefinitionStub();
        }
        super.performAddElement();
    }
}

