/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.preferences.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractValidationSettingsPage;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ScrolledPageContent;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;
import org.osgi.service.prefs.BackingStoreException;

public class HTMLValidationPreferencePage
extends AbstractValidationSettingsPage {
    public static final String PROPERTY_PAGE_ID = "org.eclipse.wst.html.ui.propertyPage.project.validation";
    public static final String PREFERENCE_PAGE_ID = "org.eclipse.wst.html.ui.preferences.validation";
    private static final int[] SEVERITIES = new int[]{1, 2, -1};
    private static final String SETTINGS_SECTION_NAME = "HTMLValidationSeverities";
    private PixelConverter fPixelConverter;
    private Button fIgnoreElementNames;
    private Label fIgnoredElementNamesLabel;
    private Text fIgnoredElementNames;
    private Button fIgnoreAttributeNames;
    private Label fIgnoredAttributeNamesLabel;
    private Text fIgnoredAttributeNames;
    private IPreferencesService fPreferencesService = Platform.getPreferencesService();
    private boolean fUseElementsOriginOverrides = false;
    private boolean fIgnoreElementNamesOriginOverride = false;
    private String fIgnoredElementNamesOriginOverride = "";
    private boolean fUseAttributesOriginOverrides = false;
    private boolean fIgnoreAttributeNamesOriginOverride = false;
    private String fIgnoredAttributeNamesOriginOverride = "";

    public void overrideIgnoredElementsOriginValues(boolean enableIgnore, String elementNames) {
        Object data;
        this.fIgnoreElementNamesOriginOverride = enableIgnore;
        this.fIgnoredElementNamesOriginOverride = elementNames;
        this.fUseElementsOriginOverrides = true;
        if (this.fIgnoreElementNames != null && (data = (BooleanData)this.fIgnoreElementNames.getData()) != null) {
            ((BooleanData)data).originalValue = this.fIgnoreElementNamesOriginOverride;
        }
        if (this.fIgnoredElementNames != null && (data = (TextData)this.fIgnoredElementNames.getData()) != null) {
            ((TextData)data).originalValue = this.fIgnoredElementNamesOriginOverride;
        }
    }

    public void overrideOriginValues(boolean enableIgnore, String attributeNames) {
        this.overrideIgnoredAttributesOriginValues(enableIgnore, attributeNames);
    }

    public void overrideIgnoredAttributesOriginValues(boolean enableIgnore, String attributeNames) {
        Object data;
        this.fIgnoreAttributeNamesOriginOverride = enableIgnore;
        this.fIgnoredAttributeNamesOriginOverride = attributeNames;
        this.fUseAttributesOriginOverrides = true;
        if (this.fIgnoreAttributeNames != null && (data = (BooleanData)this.fIgnoreAttributeNames.getData()) != null) {
            ((BooleanData)data).originalValue = this.fIgnoreAttributeNamesOriginOverride;
        }
        if (this.fIgnoredAttributeNames != null && (data = (TextData)this.fIgnoredAttributeNames.getData()) != null) {
            ((TextData)data).originalValue = this.fIgnoredAttributeNamesOriginOverride;
        }
    }

    protected Control createCommonContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        page.setLayout((Layout)layout);
        this.fPixelConverter = new PixelConverter((Control)parent);
        Composite content = this.createValidationSection(page);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        content.setLayoutData((Object)gridData);
        return page;
    }

    private Composite createValidationSection(Composite page) {
        int nColumns = 3;
        ScrolledPageContent spContent = new ScrolledPageContent(page);
        Composite composite = spContent.getBody();
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        BooleanData ignoreData = new BooleanData("ignoreElementNames");
        this.fIgnoreElementNames = new Button(composite, 32);
        this.fIgnoreElementNames.setData((Object)ignoreData);
        this.fIgnoreElementNames.setFont(page.getFont());
        this.fIgnoreElementNames.setText(HTMLUIMessages.IgnoreElementNames);
        this.fIgnoreElementNames.setEnabled(true);
        boolean ignoreElementNamesIsSelected = this.fPreferencesService.getBoolean(this.getPreferenceNodeQualifier(), ignoreData.getKey(), false, this.createPreferenceScopes());
        ignoreData.setValue(ignoreElementNamesIsSelected);
        ignoreData.originalValue = this.fUseElementsOriginOverrides ? this.fIgnoreElementNamesOriginOverride : ignoreElementNamesIsSelected;
        this.fIgnoreElementNames.setSelection(ignoreData.getValue());
        this.fIgnoreElementNames.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                HTMLValidationPreferencePage.this.controlChanged(e.widget);
            }

            public void widgetSelected(SelectionEvent e) {
                HTMLValidationPreferencePage.this.controlChanged(e.widget);
            }
        });
        this.fIgnoreElementNames.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.fIgnoredElementNamesLabel = new Label(composite, 16448);
        this.fIgnoredElementNamesLabel.setFont(composite.getFont());
        this.fIgnoredElementNamesLabel.setEnabled(ignoreData.getValue());
        this.fIgnoredElementNamesLabel.setText(HTMLUIMessages.IgnoreElementNamesPattern);
        this.fIgnoredElementNamesLabel.setLayoutData((Object)new GridData(4, 0x1000008, true, false, 3, 1));
        this.setHorizontalIndent((Control)this.fIgnoredElementNamesLabel, 20);
        TextData data = new TextData("elementNamesToIgnore");
        this.fIgnoredElementNames = new Text(composite, 2052);
        this.fIgnoredElementNames.setData((Object)data);
        this.fIgnoredElementNames.setTextLimit(500);
        this.fIgnoredElementNames.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.setHorizontalIndent((Control)this.fIgnoredElementNames, 20);
        this.setWidthHint((Control)this.fIgnoredElementNames, this.convertWidthInCharsToPixels(65));
        String ignoredElementNames = this.fPreferencesService.getString(this.getPreferenceNodeQualifier(), data.getKey(), "", this.createPreferenceScopes());
        data.setValue(ignoredElementNames);
        data.originalValue = this.fUseElementsOriginOverrides ? this.fIgnoredElementNamesOriginOverride : ignoredElementNames;
        this.fIgnoredElementNames.setText(data.getValue());
        this.fIgnoredElementNames.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (HTMLValidationPreferencePage.this.verifyIgnoredNames(HTMLValidationPreferencePage.this.fIgnoredElementNames.getText().trim())) {
                    HTMLValidationPreferencePage.this.controlChanged(e.widget);
                }
            }
        });
        this.controlChanged((Widget)this.fIgnoreElementNames);
        ignoreData = new BooleanData("ignoreAttrNames");
        this.fIgnoreAttributeNames = new Button(composite, 32);
        this.fIgnoreAttributeNames.setData((Object)ignoreData);
        this.fIgnoreAttributeNames.setFont(page.getFont());
        this.fIgnoreAttributeNames.setText(HTMLUIMessages.IgnoreAttributeNames);
        this.fIgnoreAttributeNames.setEnabled(true);
        boolean ignoreAttributeNamesIsSelected = this.fPreferencesService.getBoolean(this.getPreferenceNodeQualifier(), ignoreData.getKey(), false, this.createPreferenceScopes());
        ignoreData.setValue(ignoreAttributeNamesIsSelected);
        ignoreData.originalValue = this.fUseAttributesOriginOverrides ? this.fIgnoreAttributeNamesOriginOverride : ignoreAttributeNamesIsSelected;
        this.fIgnoreAttributeNames.setSelection(ignoreData.getValue());
        this.fIgnoreAttributeNames.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                HTMLValidationPreferencePage.this.controlChanged(e.widget);
            }

            public void widgetSelected(SelectionEvent e) {
                HTMLValidationPreferencePage.this.controlChanged(e.widget);
            }
        });
        this.fIgnoreAttributeNames.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.fIgnoredAttributeNamesLabel = new Label(composite, 16448);
        this.fIgnoredAttributeNamesLabel.setFont(composite.getFont());
        this.fIgnoredAttributeNamesLabel.setEnabled(ignoreData.getValue());
        this.fIgnoredAttributeNamesLabel.setText(HTMLUIMessages.IgnoreAttributeNamesPattern);
        this.fIgnoredAttributeNamesLabel.setLayoutData((Object)new GridData(4, 0x1000008, true, false, 3, 1));
        this.setHorizontalIndent((Control)this.fIgnoredAttributeNamesLabel, 20);
        data = new TextData("attrNamesToIgnore");
        this.fIgnoredAttributeNames = new Text(composite, 2052);
        this.fIgnoredAttributeNames.setData((Object)data);
        this.fIgnoredAttributeNames.setTextLimit(500);
        this.fIgnoredAttributeNames.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.setHorizontalIndent((Control)this.fIgnoredAttributeNames, 20);
        this.setWidthHint((Control)this.fIgnoredAttributeNames, this.convertWidthInCharsToPixels(65));
        String ignoredAttributeNames = this.fPreferencesService.getString(this.getPreferenceNodeQualifier(), data.getKey(), "", this.createPreferenceScopes());
        data.setValue(ignoredAttributeNames);
        data.originalValue = this.fUseAttributesOriginOverrides ? this.fIgnoredAttributeNamesOriginOverride : ignoredAttributeNames;
        this.fIgnoredAttributeNames.setText(data.getValue());
        this.fIgnoredAttributeNames.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (HTMLValidationPreferencePage.this.verifyIgnoredNames(HTMLValidationPreferencePage.this.fIgnoredAttributeNames.getText().trim())) {
                    HTMLValidationPreferencePage.this.controlChanged(e.widget);
                }
            }
        });
        this.controlChanged((Widget)this.fIgnoreAttributeNames);
        Label description = new Label(composite, 0);
        description.setText(HTMLUIMessages.Validation_description);
        description.setFont(page.getFont());
        String[] errorWarningIgnoreLabel = new String[]{HTMLUIMessages.Validation_Error, HTMLUIMessages.Validation_Warning, HTMLUIMessages.Validation_Ignore};
        ExpandableComposite ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_elements, nColumns);
        Composite inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        String label = HTMLUIMessages.HTMLValidationPreferencePage_8;
        this.addComboBox(inner, label, "elemUnknownName", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_9;
        this.addComboBox(inner, label, "elemInvalidName", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_10;
        this.addComboBox(inner, label, "elemStartInvalidCase", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_11;
        this.addComboBox(inner, label, "elemEndInvalidCase", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_12;
        this.addComboBox(inner, label, "elemMissingStart", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_13;
        this.addComboBox(inner, label, "elemMissingEnd", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_14;
        this.addComboBox(inner, label, "elemUnnecessaryEnd", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_15;
        this.addComboBox(inner, label, "elemInvalidDirective", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_16;
        this.addComboBox(inner, label, "elemInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_17;
        this.addComboBox(inner, label, "elemDuplicate", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_18;
        this.addComboBox(inner, label, "elemCoexistence", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_19;
        this.addComboBox(inner, label, "elemUnclosedStartTag", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_20;
        this.addComboBox(inner, label, "elemUnclosedEndTag", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_21;
        this.addComboBox(inner, label, "elemInvalidEmptyTag", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_36;
        this.addComboBox(inner, label, "elemInvalidText", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_attributes, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_0;
        this.addComboBox(inner, label, "attrUndefName", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_1;
        this.addComboBox(inner, label, "attrUndefValue", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_2;
        this.addComboBox(inner, label, "attrNameMismatch", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_3;
        this.addComboBox(inner, label, "attrInvalidName", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_4;
        this.addComboBox(inner, label, "attrInvalidValue", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_5;
        this.addComboBox(inner, label, "attrDuplicate", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_6;
        this.addComboBox(inner, label, "attrValueMismatch", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_7;
        this.addComboBox(inner, label, "attrValueUnclosed", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_37;
        this.addComboBox(inner, label, "attrValueEqualsMissing", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_35;
        this.addComboBox(inner, label, "resourceNotFound", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_document_type, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_22;
        this.addComboBox(inner, label, "docDuplicateTag", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_23;
        this.addComboBox(inner, label, "docInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_24;
        this.addComboBox(inner, label, "docDoctypeUnclosed", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_comment, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_27;
        this.addComboBox(inner, label, "commentInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_28;
        this.addComboBox(inner, label, "commentUnclosed", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_cdata, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_29;
        this.addComboBox(inner, label, "cdataInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_30;
        this.addComboBox(inner, label, "cdataUnclosed", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_pi, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_31;
        this.addComboBox(inner, label, "piInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_32;
        this.addComboBox(inner, label, "piUnclosed", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_entity_ref, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_33;
        this.addComboBox(inner, label, "refInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_34;
        this.addComboBox(inner, label, "piUndefined", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_text, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_25;
        this.addComboBox(inner, label, "docInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_26;
        this.addComboBox(inner, label, "docInvalidChar", SEVERITIES, errorWarningIgnoreLabel, 0);
        this.restoreSectionExpansionStates(this.getDialogSettings().getSection(SETTINGS_SECTION_NAME));
        return spContent;
    }

    private void setHorizontalIndent(Control control, int indent) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalIndent = indent;
        }
    }

    private void setWidthHint(Control control, int widthHint) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).widthHint = widthHint;
        }
    }

    private boolean verifyIgnoredNames(String value) {
        if (value.length() == 0) {
            return true;
        }
        String[] names = value.split(",");
        boolean valid = true;
        int i = 0;
        while (valid && names != null && i < names.length) {
            String name;
            String string = name = names[i] == null ? null : names[i].trim();
            if (name != null && name.length() > 0) {
                int j = 0;
                while (valid && j < name.length()) {
                    if (!Character.isJavaIdentifierPart(name.charAt(j)) && '-' != name.charAt(j) && '_' != name.charAt(j) && '*' != name.charAt(j) && '?' != name.charAt(j)) {
                        valid = false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!valid) {
            this.setErrorMessage(NLS.bind((String)HTMLUIMessages.BadIgnoreAttributeNamesPattern, (Object)value));
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
        return valid;
    }

    protected void controlChanged(Widget widget) {
        if (widget instanceof Text) {
            TextData data = (TextData)widget.getData();
            data.setValue(((Text)widget).getText());
        } else if (widget instanceof Button) {
            BooleanData data = (BooleanData)widget.getData();
            if (data != null) {
                data.setValue(((Button)widget).getSelection());
                if (this.fIgnoreElementNames == widget) {
                    this.fIgnoredElementNamesLabel.setEnabled(data.getValue());
                    this.fIgnoredElementNames.setEnabled(data.getValue());
                    if (data.getValue()) {
                        this.fIgnoredElementNames.setFocus();
                    }
                } else if (this.fIgnoreAttributeNames == widget) {
                    this.fIgnoredAttributeNamesLabel.setEnabled(data.getValue());
                    this.fIgnoredAttributeNames.setEnabled(data.getValue());
                    if (data.getValue()) {
                        this.fIgnoredAttributeNames.setFocus();
                    }
                }
            }
        } else {
            super.controlChanged(widget);
        }
    }

    protected boolean shouldRevalidateOnSettingsChange() {
        TextData data = (TextData)this.fIgnoredElementNames.getData();
        if (data.isChanged()) {
            return true;
        }
        BooleanData ignoreData = (BooleanData)this.fIgnoreElementNames.getData();
        if (ignoreData.isChanged()) {
            return true;
        }
        data = (TextData)this.fIgnoredAttributeNames.getData();
        if (data.isChanged()) {
            return true;
        }
        ignoreData = (BooleanData)this.fIgnoreAttributeNames.getData();
        if (ignoreData.isChanged()) {
            return true;
        }
        return super.shouldRevalidateOnSettingsChange();
    }

    protected void storeValues() {
        IScopeContext[] contexts = this.createPreferenceScopes();
        BooleanData ignoreData = (BooleanData)this.fIgnoreElementNames.getData();
        contexts[0].getNode(this.getPreferenceNodeQualifier()).putBoolean(ignoreData.getKey(), ignoreData.getValue());
        ignoreData.originalValue = ignoreData.getValue();
        TextData data = (TextData)this.fIgnoredElementNames.getData();
        contexts[0].getNode(this.getPreferenceNodeQualifier()).put(data.getKey(), data.getValue());
        data.originalValue = data.getValue();
        ignoreData = (BooleanData)this.fIgnoreAttributeNames.getData();
        contexts[0].getNode(this.getPreferenceNodeQualifier()).putBoolean(ignoreData.getKey(), ignoreData.getValue());
        ignoreData.originalValue = ignoreData.getValue();
        data = (TextData)this.fIgnoredAttributeNames.getData();
        contexts[0].getNode(this.getPreferenceNodeQualifier()).put(data.getKey(), data.getValue());
        data.originalValue = data.getValue();
        int i = 0;
        while (i < contexts.length) {
            try {
                contexts[i].getNode(this.getPreferenceNodeQualifier()).flush();
            }
            catch (BackingStoreException e) {
                Logger.logException(e);
            }
            ++i;
        }
        super.storeValues();
        this.forceReconciling();
    }

    private void forceReconciling() {
        IPreferenceStore store;
        boolean value = (store = SSEUIPlugin.getDefault().getPreferenceStore()).getBoolean(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS);
        store.setValue(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, !value);
        store.setValue(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, value);
    }

    protected void performDefaults() {
        this.resetIgnoreNamesPatterns();
        this.resetSeverities();
        super.performDefaults();
    }

    protected void resetIgnoreNamesPatterns() {
        IEclipsePreferences defaultContext = new DefaultScope().getNode(this.getPreferenceNodeQualifier());
        BooleanData ignoreData = (BooleanData)this.fIgnoreElementNames.getData();
        boolean ignoreElementNames = defaultContext.getBoolean(ignoreData.getKey(), false);
        ignoreData.setValue(ignoreElementNames);
        this.fIgnoreElementNames.setSelection(ignoreData.getValue());
        TextData data = (TextData)this.fIgnoredElementNames.getData();
        String ignoredElementNames = defaultContext.get(data.getKey(), "");
        data.setValue(ignoredElementNames);
        this.fIgnoredElementNames.setText(data.getValue());
        ignoreData = (BooleanData)this.fIgnoreAttributeNames.getData();
        boolean ignoreAttributeNames = defaultContext.getBoolean(ignoreData.getKey(), false);
        ignoreData.setValue(ignoreAttributeNames);
        this.fIgnoreAttributeNames.setSelection(ignoreData.getValue());
        data = (TextData)this.fIgnoredAttributeNames.getData();
        String ignoredAttributeNames = defaultContext.get(data.getKey(), "");
        data.setValue(ignoredAttributeNames);
        this.fIgnoredAttributeNames.setText(data.getValue());
        this.controlChanged((Widget)this.fIgnoreAttributeNames);
    }

    protected IDialogSettings getDialogSettings() {
        return HTMLUIPlugin.getDefault().getDialogSettings();
    }

    public void dispose() {
        this.storeSectionExpansionStates(this.getDialogSettings().addNewSection(SETTINGS_SECTION_NAME));
        super.dispose();
    }

    protected String getQualifier() {
        return HTMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    protected String getPreferenceNodeQualifier() {
        return HTMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    protected String getPreferencePageID() {
        return PREFERENCE_PAGE_ID;
    }

    protected String getProjectSettingsKey() {
        return "use-project-settings";
    }

    protected String getPropertyPageID() {
        return PROPERTY_PAGE_ID;
    }

    public void init(IWorkbench workbench) {
    }

    private class BooleanData {
        private String fKey;
        private boolean fValue;
        boolean originalValue = false;

        public BooleanData(String key) {
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public void setValue(boolean value) {
            this.fValue = value;
        }

        public boolean getValue() {
            return this.fValue;
        }

        boolean isChanged() {
            return this.originalValue ^ this.fValue;
        }
    }

    private class TextData {
        private String fKey;
        private String fValue;
        String originalValue = "";

        public TextData(String key) {
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public void setValue(String value) {
            this.fValue = value;
        }

        public String getValue() {
            return this.fValue != null ? this.fValue : "";
        }

        boolean isChanged() {
            return !this.originalValue.equalsIgnoreCase(this.fValue);
        }
    }
}

