/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.jst.pagedesigner.commands.CloneNodeCommand;
import org.eclipse.jst.pagedesigner.commands.MoveNodeCommand;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editpolicies.DropEditPolicy;
import org.eclipse.jst.pagedesigner.editpolicies.MoveSupport;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.validation.caret.DnDPositionValidator;
import org.eclipse.jst.pagedesigner.validation.caret.DropActionData;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.IDropLocationStrategy;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class DragMoveEditPolicy
extends DropEditPolicy {
    public final Command getCommand(Request request) {
        IDOMNode hostNode;
        if (!(request instanceof ChangeBoundsRequest)) {
            return null;
        }
        ChangeBoundsRequest r = (ChangeBoundsRequest)request;
        if (!MoveSupport.isSingleNode(r)) {
            return UnexecutableCommand.INSTANCE;
        }
        Object type = r.getType();
        if (type != "add children" && type != "clone" && type != "move children") {
            return null;
        }
        Node draggedNode = MoveSupport.getDraggedNode(r);
        if (DOMUtil.isAncester(draggedNode, (Node)(hostNode = ((NodeEditPart)this.getHost()).getIDOMNode()))) {
            return UnexecutableCommand.INSTANCE;
        }
        DesignPosition position = this.findPosition((DropRequest)r);
        if (position == null || !position.isValid()) {
            return null;
        }
        Node node = position.getContainerNode();
        if (DOMUtil.isAncester(draggedNode, node)) {
            return UnexecutableCommand.INSTANCE;
        }
        IDOMPosition domposition = DOMPositionHelper.toDOMPosition(position);
        if ("clone".equals(type)) {
            return new CloneNodeCommand((IHTMLGraphicalViewer)this.getHost().getViewer(), domposition, draggedNode);
        }
        return new MoveNodeCommand((IHTMLGraphicalViewer)this.getHost().getViewer(), domposition, draggedNode);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            return this.getHost();
        }
        return super.getTargetEditPart(request);
    }

    @Override
    protected final DesignPosition findPosition(DropRequest r) {
        IPositionMediator mediator = this.getDropChildValidator(r);
        if (mediator == null) {
            return null;
        }
        IDropLocationStrategy dropStrategy = this.createDropLocationStrategy(r);
        DesignPosition position = dropStrategy.calculateDesignPosition(this.getHost(), r.getLocation(), mediator);
        if (position != null && !mediator.isValidPosition(position)) {
            return null;
        }
        return position;
    }

    @Override
    public void showTargetFeedback(Request request) {
        Object type = request.getType();
        if (type == "add children" || type == "clone" || type == "move children" || type == "move") {
            super.showTargetFeedback(request);
        }
    }

    @Override
    protected final IPositionMediator createDefaultDropChildValidator(DropActionData.DropData r) {
        return new DnDPositionValidator(new DropActionData(6, r));
    }
}

