/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration;

public class FnAdjustDateToTimeZone
extends Function {
    private static Collection _expected_args = null;
    private static final XSDayTimeDuration minDuration = new XSDayTimeDuration(0, 14, 0, 0.0, true);
    private static final XSDayTimeDuration maxDuration = new XSDayTimeDuration(0, 14, 0, 0.0, false);

    public FnAdjustDateToTimeZone() {
        super(new QName("adjust-date-to-timezone"), 1, 2);
    }

    @Override
    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        return FnAdjustDateToTimeZone.adjustDate(args, ec.getDynamicContext());
    }

    public static ResultSequence adjustDate(Collection args, DynamicContext dc) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnAdjustDateToTimeZone.expectedArgs());
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        if (arg1.empty()) {
            return ResultBuffer.EMPTY;
        }
        ResultSequence arg2 = ResultBuffer.EMPTY;
        if (argiter.hasNext()) {
            arg2 = (ResultSequence)argiter.next();
        }
        XSDate date = (XSDate)arg1.item(0);
        XSDayTimeDuration timezone = null;
        if (arg2.empty()) {
            if (date.timezoned()) {
                XSDate localized = new XSDate(date.calendar(), null);
                return localized;
            }
            return arg1;
        }
        timezone = (XSDayTimeDuration)arg2.item(0);
        if (timezone.lt(minDuration, dc) || timezone.gt(maxDuration, dc)) {
            throw DynamicError.invalidTimezone();
        }
        if (date.tz() == null) {
            return new XSDate(date.calendar(), timezone);
        }
        XMLGregorianCalendar xmlCalendar = _datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)date.normalizeCalendar(date.calendar(), date.tz()));
        Duration duration = _datatypeFactory.newDuration(timezone.getStringValue());
        xmlCalendar.add(duration);
        return new XSDate(xmlCalendar.toGregorianCalendar(), timezone);
    }

    public static synchronized Collection expectedArgs() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSDate(), 3));
            _expected_args.add(new SeqType(new XSDayTimeDuration(), 3));
        }
        return _expected_args;
    }
}

