/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.consumption.core.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jst.ws.internal.cxf.consumption.core.CXFConsumptionCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.internal.cxf.core.resources.JavaResourceChangeListener;
import org.eclipse.jst.ws.internal.cxf.core.utils.CommandLineUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.FileUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.LaunchUtils;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class WSDL2JavaClientCommand
extends AbstractDataModelOperation {
    public static final String CXF_TOOL_CLASS_NAME = "org.apache.cxf.tools.wsdlto.WSDLToJava";
    private WSDL2JavaDataModel model;
    private JavaResourceChangeListener javaResourceChangeListener;

    public WSDL2JavaClientCommand(WSDL2JavaDataModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        this.javaResourceChangeListener = new JavaResourceChangeListener((IPath)new Path(this.model.getJavaSourceFolder()));
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener, 1);
        String[] progArgs = CommandLineUtils.getWSDL2JavaGenerateClientArguments((WSDL2JavaDataModel)this.model);
        try {
            String projectName = this.model.getProjectName();
            IJavaProject javaProject = JDTUtils.getJavaProject((String)projectName);
            LaunchUtils.launch((IJavaProject)javaProject, (String)CXF_TOOL_CLASS_NAME, (String[])progArgs);
            FileUtils.copyW2JFilesFromTmp((WSDL2JavaDataModel)this.model, (IEnvironment)this.getEnvironment());
        }
        catch (CoreException ce) {
            status = ce.getStatus();
            CXFConsumptionCorePlugin.log(status);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener);
        return status;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        ArrayList changedResources = new ArrayList();
        changedResources.addAll(this.javaResourceChangeListener.getChangedResources());
        if (changedResources.size() > 0) {
            for (IResource resource : changedResources) {
                try {
                    resource.delete(true, monitor);
                }
                catch (CoreException ce) {
                    status = ce.getStatus();
                    CXFConsumptionCorePlugin.log(status);
                }
            }
        }
        return status;
    }

    public void setJavaSourceFolder(String javaSourceFolder) {
        this.model.setJavaSourceFolder(javaSourceFolder);
    }

    public void setServiceName(String serviceName) {
        this.model.setServiceName(serviceName);
    }

    public void setGenerateServer(boolean generateServer) {
        this.model.setGenerateServer(generateServer);
    }

    public void setGenerateClient(boolean generateClient) {
        this.model.setGenerateClient(generateClient);
    }

    public void setGenerateImplementation(boolean generateImplementation) {
        this.model.setGenerateImplementation(generateImplementation);
    }

    public void setUseDefaultValues(boolean useDefaultValues) {
        this.model.setUseDefaultValues(useDefaultValues);
    }

    public void setProcessSOAPHeaders(boolean processSOAPHeaders) {
        this.model.setProcessSOAPHeaders(processSOAPHeaders);
    }

    public void setLoadDefaultNamespacePackageNameMapping(boolean loadDefaultNamespacePackageNameMapping) {
        this.model.setLoadDefaultNamespacePackageNameMapping(loadDefaultNamespacePackageNameMapping);
    }

    public void setLoadDefaultExcludesNamepsaceMapping(boolean loadDefaultExcludesNamepsaceMapping) {
        this.model.setLoadDefaultExcludesNamepsaceMapping(loadDefaultExcludesNamepsaceMapping);
    }

    public void setAutoNameResolution(boolean autoNameResolution) {
        this.model.setAutoNameResolution(autoNameResolution);
    }

    public void setXjcUseDefaultValues(boolean xjcUseDefaultValues) {
        this.model.setXjcUseDefaultValues(xjcUseDefaultValues);
    }

    public void setXjcToString(boolean xjcToString) {
        this.model.setXjcToStringSimple(xjcToString);
    }

    public void setXjcToStringSimple(boolean xjcToStringSimple) {
        this.model.setXjcToStringSimple(xjcToStringSimple);
    }

    public void setXjcToStringMultiLine(boolean xjcToStringMultiLine) {
        this.model.setXjcToStringMultiLine(xjcToStringMultiLine);
    }

    public void setXjcLocator(boolean xjcLocator) {
        this.model.setXjcLocator(xjcLocator);
    }

    public void setXjcSyncMethods(boolean xjcSyncMethods) {
        this.model.setXjcSyncMethods(xjcSyncMethods);
    }

    public void setXjcMarkGenerated(boolean xjcMarkGenerated) {
        this.model.setXjcMarkGenerated(xjcMarkGenerated);
    }

    public void setIncludedNamespaces(Map value) {
        this.model.setIncludedNamespaces(value);
    }

    public void setBindingFiles(List<String> bindingFiles) {
        for (String path : bindingFiles) {
            this.model.getBindingFiles().add(path);
        }
    }
}

